/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.tree.operator;

import it.units.inginf.male.tree.Anchor;
import it.units.inginf.male.tree.Constant;
import it.units.inginf.male.tree.DescriptionContext;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.tree.operator.Concatenator;
import it.units.inginf.male.tree.operator.Group;
import it.units.inginf.male.tree.operator.Lookaround;
import it.units.inginf.male.tree.operator.MatchMinMaxGreedy;
import it.units.inginf.male.tree.operator.NonCapturingGroup;
import it.units.inginf.male.tree.operator.Quantifier;
import it.units.inginf.male.tree.operator.TernaryOperator;

public class MatchMinMax
extends TernaryOperator {
    static final int MAX_N_GENERATION = 20;

    @Override
    protected TernaryOperator buildCopy() {
        return new MatchMinMax();
    }

    @Override
    public void describe(StringBuilder builder, DescriptionContext context, Node.RegexFlavour flavour) {
        StringBuilder tmp = new StringBuilder();
        Node child = this.getFirst();
        int index = context.incGroups();
        child.describe(tmp, context, flavour);
        int l = child.isEscaped() ? tmp.length() - 1 : tmp.length();
        boolean group = l > 1 && !child.isCharacterClass() && !(child instanceof Group) && !(child instanceof NonCapturingGroup);
        switch (flavour) {
            case JAVA: {
                if (group) {
                    builder.append("(?:");
                    builder.append((CharSequence)tmp);
                    builder.append(")");
                } else {
                    builder.append((CharSequence)tmp);
                }
                builder.append("{");
                builder.append(Integer.parseInt(this.getSecond().toString()));
                builder.append(",");
                builder.append(Integer.parseInt(this.getThird().toString()));
                builder.append("}+");
                break;
            }
            default: {
                builder.append("(?=(");
                if (group) {
                    builder.append("(?:");
                    builder.append((CharSequence)tmp);
                    builder.append(")");
                } else {
                    builder.append((CharSequence)tmp);
                }
                builder.append("{");
                builder.append(Integer.parseInt(this.getSecond().toString()));
                builder.append(",");
                builder.append(Integer.parseInt(this.getThird().toString()));
                builder.append("}))\\").append(index);
                context.incExpansionGroups();
            }
        }
    }

    @Override
    public boolean isValid() {
        Node first = this.getFirst();
        boolean validFirst = first.isValid() && !(first instanceof Concatenator) && !(first instanceof Quantifier) && !(first instanceof MatchMinMax) && !(first instanceof MatchMinMaxGreedy) && !(first instanceof Anchor) && !(first instanceof Lookaround);
        Node second = this.getSecond();
        Node third = this.getThird();
        if (third instanceof Constant && second instanceof Constant) {
            int rightValue;
            int leftValue;
            try {
                leftValue = Integer.parseInt(second.toString());
                rightValue = Integer.parseInt(third.toString());
            }
            catch (NumberFormatException ex) {
                return false;
            }
            if (leftValue < 0 || rightValue < 0) {
                return false;
            }
            if (leftValue >= rightValue) {
                return false;
            }
            return validFirst;
        }
        return false;
    }
}

