/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.tree;

import it.units.inginf.male.tree.AbstractNode;
import it.units.inginf.male.tree.DescriptionContext;
import it.units.inginf.male.tree.Leaf;
import it.units.inginf.male.tree.Node;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Constant
extends AbstractNode
implements Leaf {
    private Node parent;
    protected String value;
    private boolean charClass;
    Set<String> allowedClasses = new HashSet<String>(Arrays.asList("\\w", "\\d", ".", "\\b", "\\s"));
    private boolean escaped;

    public Constant(String value) {
        this.value = value;
        this.charClass = this.allowedClasses.contains(value);
        this.escaped = value.startsWith("\\");
    }

    @Override
    public int getMinChildrenCount() {
        return 0;
    }

    @Override
    public int getMaxChildrenCount() {
        return 0;
    }

    @Override
    public void describe(StringBuilder builder, DescriptionContext context, Node.RegexFlavour flavour) {
        builder.append(this.value);
    }

    @Override
    public Leaf cloneTree() {
        Constant clone = new Constant(this.value);
        return clone;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public List<Node> getChildrens() {
        return Collections.emptyList();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public boolean isCharacterClass() {
        return this.charClass;
    }

    @Override
    public boolean isEscaped() {
        return this.escaped;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Constant other = (Constant)obj;
        return Objects.equals(this.value, other.value);
    }
}

