/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.console;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.units.inginf.male.Main;
import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.dto.SimpleConfig;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.outputs.FinalSolution;
import it.units.inginf.male.outputs.Results;
import it.units.inginf.male.postprocessing.JsonPostProcessor;
import it.units.inginf.male.postprocessing.Postprocessor;
import it.units.inginf.male.strategy.ExecutionListenerFactory;
import it.units.inginf.male.strategy.ExecutionStrategy;
import it.units.inginf.male.strategy.impl.CoolTextualExecutionListener;
import it.units.inginf.male.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleRegexTurtle {
    private static String WARNING_MESSAGE = "\nWARNING\nThe quality of the solution depends on a number of factors, including size and syntactical properties of the learning information.\nThe algorithms embedded in this experimental prototype have always been tested with at least 25 matches over at least 2 examples.\nIt is very unlikely that a smaller number of matches allows obtaining a useful solution.\n";
    private static final String HELP_MESSAGE = "Usage:\njava -jar ConsoleRegexTurtle -t 4 -p 500 -g 1000 -e 20.0 -c \"interesting evolution\" -x true -d dataset.json -o ./outputfolder/\n\nOn linux you can invoke this tool using the alternative script:\nregexturtle.sh -t 4 -p 500 -g 1000 -e 20.0 -c \"interesting evolution\" -d dataset.json -o ./outputfolder/\n\nParameters:\n-t number of threads, default is 2\n-p population size, default is 500\n-g maximum number of generations, per Job, default si 1000\n-j number of Jobs, default si 32\n-e percentange of number generations, defines a threshold for the separate and conquer split criteria, when best doesn't change for the provided % of generation the Job evolution separates the dataset.\n   Default is 20%, 200 geberations with default 1000 generations.\n-d path of the dataset json file containing the examples, this parameter is mandatory.\n-o name of the output folder, results.json is saved into this folder; default is '.'\n-x boolean, populates an extra field in results file, when 'true' adds all dataset examples in the results file 'examples' field, default is 'false'\n-s boolean, when 'true' enables dataset striping, striping is an experimental feature, default is disabled: 'false'\n-c adds an optional comment string\n-h visualizes this help message\n";

    public static void main(String[] args) {
        SimpleConfig simpleConfiguration = new SimpleConfig();
        simpleConfiguration.datasetName = "./dataset.json";
        simpleConfiguration.outputFolder = ".";
        simpleConfiguration.numberOfJobs = 32;
        simpleConfiguration.generations = 1000;
        simpleConfiguration.numberThreads = 4;
        simpleConfiguration.populationSize = 500;
        simpleConfiguration.termination = 20.0;
        simpleConfiguration.populateOptionalFields = false;
        simpleConfiguration.isStriped = false;
        ConsoleRegexTurtle.parseArgs(args, simpleConfiguration);
        try {
            simpleConfiguration.dataset = ConsoleRegexTurtle.loadDataset(simpleConfiguration.datasetName);
        }
        catch (IOException ex) {
            System.out.println("Problem opening the dataset file " + simpleConfiguration.datasetName + "\n");
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(1);
        }
        String message = null;
        int numberPositiveExamples = 0;
        for (DataSet.Example example : simpleConfiguration.dataset.getExamples()) {
            if (example.getNumberMatches() <= 0) continue;
            ++numberPositiveExamples;
        }
        if (simpleConfiguration.dataset.getNumberMatches() < 25 || numberPositiveExamples < 2) {
            message = WARNING_MESSAGE;
        }
        Configuration config = simpleConfiguration.buildConfiguration();
        config.setPostProcessor((Postprocessor)new JsonPostProcessor());
        config.getPostprocessorParameters().put("populateOptionalFields", Boolean.toString(simpleConfiguration.populateOptionalFields));
        config.setOutputFolderName(simpleConfiguration.outputFolder);
        Results results = new Results(config);
        results.setComment(simpleConfiguration.comment);
        try {
            results.setMachineHardwareSpecifications(Utils.cpuInfo());
        }
        catch (IOException ex) {
            Logger.getLogger(ConsoleRegexTurtle.class.getName()).log(Level.SEVERE, null, ex);
        }
        CoolTextualExecutionListener consolelistener = new CoolTextualExecutionListener(message, config, results);
        long startTime = System.currentTimeMillis();
        ExecutionStrategy strategy = config.getStrategy();
        try {
            strategy.execute(config, (ExecutionListenerFactory)consolelistener);
        }
        catch (Exception ex) {
            Logger.getLogger(ConsoleRegexTurtle.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (config.getPostProcessor() != null) {
            startTime = System.currentTimeMillis() - startTime;
            config.getPostProcessor().elaborate(config, results, startTime);
        }
        ConsoleRegexTurtle.writeBestPerformances(results.getBestSolution());
    }

    private static DataSet loadDataset(String dataSetFilename) throws IOException {
        StringBuilder sb;
        FileInputStream fis = new FileInputStream(new File(dataSetFilename));
        InputStreamReader isr = new InputStreamReader(fis);
        try (BufferedReader bufferedReader = new BufferedReader(isr);){
            String line;
            sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
        }
        String json = sb.toString();
        return ConsoleRegexTurtle.loadDatasetJson(json);
    }

    private static DataSet loadDatasetJson(String jsonDataset) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        DataSet dataset = (DataSet)gson.fromJson(jsonDataset, DataSet.class);
        return dataset;
    }

    private static void writeBestPerformances(FinalSolution solution) {
        if (solution != null) {
            System.out.println("Best on learning (JAVA): " + solution.getSolution());
            System.out.println("Best on learning (JS): " + solution.getSolutionJS());
            System.out.println("******Stats on training******");
            System.out.println("F-measure: " + solution.getTrainingPerformances().get("match f-measure"));
            System.out.println("Precision: " + solution.getTrainingPerformances().get("match precision"));
            System.out.println("Recall: " + solution.getTrainingPerformances().get("match recall"));
            System.out.println("Char precision: " + solution.getTrainingPerformances().get("character precision"));
            System.out.println("Char recall: " + solution.getTrainingPerformances().get("character recall"));
            System.out.println("******Stats on validation******");
            System.out.println("F-measure " + solution.getValidationPerformances().get("match f-measure"));
            System.out.println("Precision: " + solution.getValidationPerformances().get("match precision"));
            System.out.println("Recall: " + solution.getValidationPerformances().get("match recall"));
            System.out.println("Char precision: " + solution.getValidationPerformances().get("character precision"));
            System.out.println("Char recall: " + solution.getValidationPerformances().get("character recall"));
            System.out.println("******Stats on learning******");
            System.out.println("F-measure: " + solution.getLearningPerformances().get("match f-measure"));
            System.out.println("Precision: " + solution.getLearningPerformances().get("match precision"));
            System.out.println("Recall: " + solution.getLearningPerformances().get("match recall"));
            System.out.println("Char precision: " + solution.getLearningPerformances().get("character precision"));
            System.out.println("Char recall: " + solution.getLearningPerformances().get("character recall"));
        }
    }

    private static void parseArgs(String[] args, SimpleConfig simpleConfig) {
        try {
            boolean mandatoryDatasetCheck = true;
            if (args.length == 0) {
                System.out.println(HELP_MESSAGE);
            }
            block28: for (int i = 0; i < args.length; ++i) {
                String string = args[i];
                String parameter = args[++i];
                switch (string) {
                    case "-t": {
                        simpleConfig.numberThreads = Integer.valueOf(parameter);
                        continue block28;
                    }
                    case "-p": {
                        simpleConfig.populationSize = Integer.valueOf(parameter);
                        continue block28;
                    }
                    case "-d": {
                        simpleConfig.datasetName = parameter;
                        mandatoryDatasetCheck = false;
                        continue block28;
                    }
                    case "-o": {
                        simpleConfig.outputFolder = parameter;
                        continue block28;
                    }
                    case "-g": {
                        simpleConfig.generations = Integer.valueOf(parameter);
                        continue block28;
                    }
                    case "-j": {
                        simpleConfig.numberOfJobs = Integer.valueOf(parameter);
                        continue block28;
                    }
                    case "-e": {
                        simpleConfig.termination = Double.valueOf(parameter);
                        continue block28;
                    }
                    case "-x": {
                        simpleConfig.populateOptionalFields = Boolean.valueOf(parameter);
                        continue block28;
                    }
                    case "-h": {
                        System.out.println(HELP_MESSAGE);
                        continue block28;
                    }
                    case "-c": {
                        simpleConfig.comment = parameter;
                        continue block28;
                    }
                    case "-s": {
                        simpleConfig.isStriped = Boolean.valueOf(parameter);
                    }
                }
            }
            if (mandatoryDatasetCheck) {
                System.out.println("Dataset path is needed.\nUsage:\njava -jar ConsoleRegexTurtle -t 4 -p 500 -g 1000 -e 20.0 -c \"interesting evolution\" -x true -d dataset.json -o ./outputfolder/\n\nOn linux you can invoke this tool using the alternative script:\nregexturtle.sh -t 4 -p 500 -g 1000 -e 20.0 -c \"interesting evolution\" -d dataset.json -o ./outputfolder/\n\nParameters:\n-t number of threads, default is 2\n-p population size, default is 500\n-g maximum number of generations, per Job, default si 1000\n-j number of Jobs, default si 32\n-e percentange of number generations, defines a threshold for the separate and conquer split criteria, when best doesn't change for the provided % of generation the Job evolution separates the dataset.\n   Default is 20%, 200 geberations with default 1000 generations.\n-d path of the dataset json file containing the examples, this parameter is mandatory.\n-o name of the output folder, results.json is saved into this folder; default is '.'\n-x boolean, populates an extra field in results file, when 'true' adds all dataset examples in the results file 'examples' field, default is 'false'\n-s boolean, when 'true' enables dataset striping, striping is an experimental feature, default is disabled: 'false'\n-c adds an optional comment string\n-h visualizes this help message\n");
                System.exit(1);
            }
        }
        catch (RuntimeException ex) {
            System.out.println("Problem parsing commandline parameters.\nUsage:\njava -jar ConsoleRegexTurtle -t 4 -p 500 -g 1000 -e 20.0 -c \"interesting evolution\" -x true -d dataset.json -o ./outputfolder/\n\nOn linux you can invoke this tool using the alternative script:\nregexturtle.sh -t 4 -p 500 -g 1000 -e 20.0 -c \"interesting evolution\" -d dataset.json -o ./outputfolder/\n\nParameters:\n-t number of threads, default is 2\n-p population size, default is 500\n-g maximum number of generations, per Job, default si 1000\n-j number of Jobs, default si 32\n-e percentange of number generations, defines a threshold for the separate and conquer split criteria, when best doesn't change for the provided % of generation the Job evolution separates the dataset.\n   Default is 20%, 200 geberations with default 1000 generations.\n-d path of the dataset json file containing the examples, this parameter is mandatory.\n-o name of the output folder, results.json is saved into this folder; default is '.'\n-x boolean, populates an extra field in results file, when 'true' adds all dataset examples in the results file 'examples' field, default is 'false'\n-s boolean, when 'true' enables dataset striping, striping is an experimental feature, default is disabled: 'false'\n-c adds an optional comment string\n-h visualizes this help message\n");
            System.out.println("Error details:" + ex.toString());
            System.exit(1);
        }
    }
}

