/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.generations;

import it.units.inginf.male.generations.Generation;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.tree.Leaf;
import it.units.inginf.male.tree.Node;
import java.util.ArrayList;
import java.util.List;

public class Full
implements Generation {
    int maxDepth;
    Context context;

    public Full(int maxDepth, Context context) {
        this.maxDepth = maxDepth;
        this.context = context;
    }

    @Override
    public List<Node> generate(int popSize) {
        ArrayList<Node> population = new ArrayList<Node>();
        int i = 0;
        while (i < popSize) {
            Node candidate = this.full(1);
            if (!candidate.isValid()) continue;
            population.add(candidate);
            ++i;
        }
        return population;
    }

    private Node full(int depth) {
        Node tree = this.randomFunction();
        if (depth >= this.maxDepth - 1) {
            for (int i = tree.getMaxChildrenCount() - tree.getMinChildrenCount(); i < tree.getMaxChildrenCount(); ++i) {
                Leaf leaf = this.randomLeaf();
                leaf.setParent(tree);
                tree.getChildrens().add(leaf);
            }
        } else {
            for (int i = tree.getMaxChildrenCount() - tree.getMinChildrenCount(); i < tree.getMaxChildrenCount(); ++i) {
                Node node = this.full(depth + 1);
                node.setParent(tree);
                tree.getChildrens().add(node);
            }
        }
        return tree;
    }

    private Node randomFunction() {
        List<Node> functionSet = this.context.getConfiguration().getNodeFactory().getFunctionSet();
        return functionSet.get(this.context.getRandom().nextInt(functionSet.size())).cloneTree();
    }

    private Leaf randomLeaf() {
        List<Leaf> terminalSet = this.context.getConfiguration().getNodeFactory().getTerminalSet();
        return terminalSet.get(this.context.getRandom().nextInt(terminalSet.size())).cloneTree();
    }
}

