/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.generations;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.generations.InitialPopulationBuilder;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.tree.Constant;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.tree.RegexRange;
import it.units.inginf.male.tree.operator.Concatenator;
import it.units.inginf.male.tree.operator.ListMatch;
import it.units.inginf.male.tree.operator.MatchOneOrMore;
import it.units.inginf.male.utils.BasicTokenizer;
import it.units.inginf.male.utils.Tokenizer;
import it.units.inginf.male.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TokenizedPopulationBuilder
implements InitialPopulationBuilder {
    private List<Node> population = new LinkedList<Node>();
    private Map<String, Double> winnerTokens = new HashMap<String, Double>();
    private Tokenizer tokenizer = new BasicTokenizer();

    @Override
    public List<Node> init() {
        return new ArrayList<Node>(this.population);
    }

    private boolean matchW(String string) {
        return string.length() == 1 && this.matchW(string.charAt(0));
    }

    private boolean matchW(char character) {
        return Character.isAlphabetic(character) || Character.isDigit(character) || character == '_';
    }

    @Override
    public void setup(Configuration configuration) {
        DataSet trainingDataset = configuration.getDatasetContainer().getTrainingDataset();
        this.population.addAll(this.setup(configuration, trainingDataset));
    }

    private List<Node> setup(Configuration configuration, DataSet usedTrainingDataset) {
        HashMap<String, Double> tokensCounter = new HashMap<String, Double>();
        LinkedList<List<String>> matchTokens = new LinkedList<List<String>>();
        LinkedList<Node> newPopulation = new LinkedList<Node>();
        DataSet dataSet = usedTrainingDataset;
        Double TOKEN_THREASHOLD = 80.0;
        boolean DISCARD_W_TOKENS = true;
        Map<String, String> parameters = configuration.getPopulationBuilderParameters();
        if (parameters != null) {
            if (parameters.containsKey("tokenThreashold")) {
                TOKEN_THREASHOLD = Double.valueOf(parameters.get("tokenThreashold"));
            }
            if (parameters.containsKey("discardWtokens")) {
                DISCARD_W_TOKENS = Boolean.valueOf(parameters.get("discardWtokens"));
            }
        }
        for (DataSet.Example example : dataSet.getExamples()) {
            for (String match : example.getMatchedStrings()) {
                List<String> list = this.tokenizer.tokenize(match);
                matchTokens.add(list);
                HashSet<String> tokensSet = new HashSet<String>(list);
                for (String token : tokensSet) {
                    if (this.matchW(token) && DISCARD_W_TOKENS) continue;
                    if (tokensCounter.containsKey(token)) {
                        Double value;
                        Double d = value = (Double)tokensCounter.get(token);
                        Double d2 = value = Double.valueOf(value + 1.0);
                        tokensCounter.put(token, value);
                        continue;
                    }
                    tokensCounter.put(token, 1.0);
                }
            }
        }
        int numberOfMatches = dataSet.getNumberMatches();
        for (Map.Entry entry : tokensCounter.entrySet()) {
            String key = (String)entry.getKey();
            Double d = (Double)entry.getValue();
            Double doublePercentange = d * 100.0 / (double)numberOfMatches;
            entry.setValue(doublePercentange);
            if (!(doublePercentange >= TOKEN_THREASHOLD)) continue;
            this.winnerTokens.put(key, doublePercentange);
        }
        int popSize = configuration.getEvolutionParameters().getPopulationSize();
        boolean bl = false;
        for (List list : matchTokens) {
            newPopulation.add(this.createIndividualFromString(list, true, this.winnerTokens));
            newPopulation.add(this.createIndividualFromString(list, false, this.winnerTokens));
            if ((var12_18 += 2) < popSize) continue;
            break;
        }
        return newPopulation;
    }

    private Node createIndividualFromString(List<String> tokenizedString, boolean compact, Map<String, Double> winnerTokens) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        LinkedList<Node> tmp = new LinkedList<Node>();
        String w = "\\w";
        String d = "\\d";
        ListMatch letters = new ListMatch();
        letters.getChildrens().add(new RegexRange("A-Za-z"));
        for (String token : tokenizedString) {
            if (winnerTokens.containsKey(token)) {
                nodes.add(new Constant(Utils.escape(token)));
                continue;
            }
            for (char c : token.toCharArray()) {
                if (Character.isLetter(c)) {
                    nodes.add(letters.cloneTree());
                    continue;
                }
                if (Character.isDigit(c)) {
                    nodes.add(new Constant(d));
                    continue;
                }
                nodes.add(new Constant(Utils.escape(c)));
            }
        }
        if (compact) {
            LinkedList<Node> newNodes = new LinkedList<Node>();
            while (nodes.size() > 0) {
                Node next;
                String nextValue;
                Node node = (Node)nodes.pollFirst();
                String nodeValue = node.toString();
                boolean isRepeat = false;
                while (nodes.size() > 0 && nodeValue.equals(nextValue = (next = (Node)nodes.peek()).toString())) {
                    isRepeat = true;
                    nodes.pollFirst();
                }
                if (isRepeat) {
                    MatchOneOrMore finalNode = new MatchOneOrMore();
                    finalNode.getChildrens().add(node);
                    node = finalNode;
                }
                newNodes.add(node);
            }
            nodes = newNodes;
        }
        while (nodes.size() > 1) {
            while (nodes.size() > 0) {
                Node first = (Node)nodes.pollFirst();
                Node second = (Node)nodes.pollFirst();
                if (second != null) {
                    Concatenator conc = new Concatenator();
                    conc.getChildrens().add(first);
                    conc.getChildrens().add(second);
                    first.setParent(conc);
                    second.setParent(conc);
                    tmp.addLast(conc);
                    continue;
                }
                tmp.addLast(first);
            }
            nodes = tmp;
            tmp = new LinkedList();
        }
        return (Node)nodes.getFirst();
    }

    @Override
    public List<Node> init(Context context) {
        return this.setup(context.getConfiguration(), context.getCurrentDataSet());
    }
}

