/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.postprocessing;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.evaluators.TreeEvaluator;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.outputs.Results;
import it.units.inginf.male.postprocessing.Postprocessor;
import it.units.inginf.male.tree.Constant;
import it.units.inginf.male.utils.BasicStats;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicPostprocessor
implements Postprocessor {
    private static Logger LOG = Logger.getLogger(BasicPostprocessor.class.getName());
    private boolean populateOptionalFields = true;
    public static final String PARAMETER_NAME_POPULATE_OPTIONAL_FIELDS = "populateOptionalFields";

    @Override
    public void setup(Map<String, String> parameters) {
    }

    @Override
    public void elaborate(Configuration config, Results results, long timeTaken) {
        Map<String, String> parameters = config.getPostprocessorParameters();
        if (parameters != null && parameters.containsKey(PARAMETER_NAME_POPULATE_OPTIONAL_FIELDS)) {
            this.populateOptionalFields = Boolean.valueOf(parameters.get(PARAMETER_NAME_POPULATE_OPTIONAL_FIELDS));
        }
        config.getBestSelector().elaborate(results);
        results.setOverallExecutionTimeMillis(timeTaken);
        if (this.populateOptionalFields) {
            results.setExamples(config.getDatasetContainer().getDataset().getExamples());
        }
        try {
            results.setBestExtractions(this.getEvaluations(results.getBestSolution().getSolution(), config, Context.EvaluationPhases.LEARNING));
            results.setBestExtractionsStrings(this.getEvaluationsStrings(results.getBestExtractions(), config.getDatasetContainer().getLearningDataset()));
            results.setBestExtractionsStats(this.getEvaluationStats(results.getBestExtractions(), config));
        }
        catch (TreeEvaluationException ex) {
            Logger.getLogger(BasicPostprocessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        DataSet training = config.getDatasetContainer().getTrainingDataset();
        DataSet learning = config.getDatasetContainer().getLearningDataset();
        int numberTrainingMatches = training.getNumberMatches();
        int numberTrainingUnmatches = training.getNumberUnmatches();
        results.setNumberTrainingMatches(numberTrainingMatches);
        results.setNumberTrainingUnmatches(numberTrainingUnmatches);
        int numberMatches = learning.getNumberMatches();
        int numberUnmatches = learning.getNumberUnmatches();
        int numberMatchedChars = learning.getNumberMatchedChars();
        int numberUnmatchedChars = learning.getNumberUnmatchedChars();
        int numberAllChars = config.getDatasetContainer().getDataset().getNumberOfChars();
        results.setNumberMatches(numberMatches);
        results.setNumberUnmatches(numberUnmatches);
        results.setNumberMatchedChars(numberMatchedChars);
        results.setNumberUnmatchedChars(numberUnmatchedChars);
        results.setNumberAllChars(numberAllChars);
    }

    private List<List<DataSet.Bounds>> getEvaluations(String solution, Configuration configuration, Context.EvaluationPhases phase) throws TreeEvaluationException {
        TreeEvaluator treeEvaluator = configuration.getEvaluator();
        Constant bestIndividualReplica = new Constant(solution);
        return treeEvaluator.evaluate(bestIndividualReplica, new Context(phase, configuration));
    }

    private List<List<String>> getEvaluationsStrings(List<List<DataSet.Bounds>> extractions, DataSet dataset) {
        LinkedList<List<String>> evaluationsStrings = new LinkedList<List<String>>();
        Iterator<DataSet.Example> it = dataset.getExamples().iterator();
        for (List<DataSet.Bounds> extractionsOfExample : extractions) {
            DataSet.Example example = it.next();
            LinkedList<String> extractionsOfExampleStrings = new LinkedList<String>();
            for (DataSet.Bounds bounds : extractionsOfExample) {
                extractionsOfExampleStrings.add(example.getString().substring(bounds.start, bounds.end));
            }
            evaluationsStrings.add(extractionsOfExampleStrings);
        }
        return evaluationsStrings;
    }

    private List<BasicStats> getEvaluationStats(List<List<DataSet.Bounds>> evaluation, Configuration config) throws TreeEvaluationException {
        DataSet dataset = config.getDatasetContainer().getLearningDataset();
        LinkedList<BasicStats> statsPerExample = new LinkedList<BasicStats>();
        for (int index = 0; index < dataset.getExamples().size(); ++index) {
            List<DataSet.Bounds> extractionsList = evaluation.get(index);
            HashSet<DataSet.Bounds> extractionsSet = new HashSet<DataSet.Bounds>(extractionsList);
            DataSet.Example example = dataset.getExample(index);
            extractionsSet.removeAll(example.getMatch());
            BasicStats exampleStats = new BasicStats();
            exampleStats.fn = -1L;
            exampleStats.fp = extractionsSet.size();
            exampleStats.tp = (long)extractionsList.size() - exampleStats.fp;
            exampleStats.tn = -1L;
            statsPerExample.add(exampleStats);
        }
        return statsPerExample;
    }
}

