/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.strategy.impl;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.evaluators.TreeEvaluator;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.objective.Objective;
import it.units.inginf.male.objective.Ranking;
import it.units.inginf.male.objective.performance.PerformacesObjective;
import it.units.inginf.male.objective.performance.PerformancesFactory;
import it.units.inginf.male.outputs.FinalSolution;
import it.units.inginf.male.outputs.JobEvolutionTrace;
import it.units.inginf.male.outputs.Results;
import it.units.inginf.male.strategy.ExecutionListener;
import it.units.inginf.male.strategy.ExecutionListenerFactory;
import it.units.inginf.male.strategy.ExecutionStrategy;
import it.units.inginf.male.strategy.RunStrategy;
import it.units.inginf.male.strategy.impl.BasicExecutionStatus;
import it.units.inginf.male.strategy.impl.DefaultExecutionListener;
import it.units.inginf.male.tree.Constant;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.utils.BasicStats;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicExecutionListener
implements ExecutionListener,
ExecutionListenerFactory {
    private static final Logger LOG = Logger.getLogger(DefaultExecutionListener.class.getName());
    private final Map<Integer, Long> jobStartTimes = new ConcurrentHashMap<Integer, Long>();
    private final NavigableSet<Integer> remove = new TreeSet<Integer>();
    private long startTime = System.currentTimeMillis();
    private boolean callPostProcessorAutomatically = false;
    private final Results results;
    private final Configuration configuration;
    private BasicExecutionStatus status = new BasicExecutionStatus();
    private boolean firstEvolution = true;

    public BasicExecutionListener(Configuration configuration, Results results, boolean callPostProcessorAutomatically) {
        this(configuration, results);
        this.callPostProcessorAutomatically = callPostProcessorAutomatically;
    }

    public BasicExecutionListener(Configuration configuration, Results results) {
        this.configuration = configuration;
        this.status.jobTotal = configuration.getJobs();
        this.status.overallGenerations = configuration.getEvolutionParameters().getGenerations() * this.status.jobTotal;
        this.status.isSearchRunning = true;
        this.status.hasFinalResult = false;
        this.results = results;
    }

    @Override
    public void evolutionStarted(RunStrategy strategy) {
        int jobId = strategy.getConfiguration().getJobId();
        this.jobStartTimes.put(jobId, System.currentTimeMillis());
        if (this.firstEvolution) {
            this.startTime = System.currentTimeMillis();
            this.firstEvolution = false;
        }
    }

    @Override
    public void logGeneration(RunStrategy strategy, int generation, Node best, double[] fitness, List<Ranking> population) {
        int jobId = strategy.getConfiguration().getJobId();
        ++this.status.overallGenerationsDone;
        double timeTakenPerGen = (double)(System.currentTimeMillis() - this.startTime) / (double)this.status.overallGenerationsDone;
        long elapsedMillis = (long)((double)(this.status.overallGenerations - this.status.overallGenerationsDone) * timeTakenPerGen);
        this.status.evolutionEta = String.format("%d h, %d m, %d s", TimeUnit.MILLISECONDS.toHours(elapsedMillis), TimeUnit.MILLISECONDS.toMinutes(elapsedMillis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(elapsedMillis)), TimeUnit.MILLISECONDS.toSeconds(elapsedMillis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(elapsedMillis)));
        Ranking bestRanking = new Ranking(best, fitness);
        FinalSolution generationBestSolution = new FinalSolution(bestRanking);
        Objective trainingObjective = PerformancesFactory.buildObjective(Context.EvaluationPhases.TRAINING, strategy.getConfiguration());
        double[] trainingPerformace = trainingObjective.fitness(best);
        PerformacesObjective.populatePerformancesMap(trainingPerformace, generationBestSolution.getTrainingPerformances());
        this.status.updateBest(generationBestSolution);
        this.results.addCharachterEvaluated(strategy.getContext().getCurrentDataSet().getNumberOfChars() * population.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evolutionComplete(RunStrategy strategy, int generation, List<Ranking> population) {
        int jobId = strategy.getConfiguration().getJobId();
        long executionTime = System.currentTimeMillis() - this.jobStartTimes.remove(jobId);
        int jumpedGenerations = strategy.getConfiguration().getEvolutionParameters().getGenerations() - generation;
        this.status.overallGenerationsDone += jumpedGenerations;
        NavigableSet<Integer> navigableSet = this.remove;
        synchronized (navigableSet) {
            this.remove.add(jobId);
        }
        ++this.status.jobDone;
        JobEvolutionTrace jobTrace = this.results.getJobTrace(jobId);
        jobTrace.setExecutionTime(executionTime);
        Objective trainingObjective = PerformancesFactory.buildObjective(Context.EvaluationPhases.TRAINING, strategy.getConfiguration());
        Objective validationObjective = PerformancesFactory.buildObjective(Context.EvaluationPhases.VALIDATION, strategy.getConfiguration());
        Objective learningObjective = PerformancesFactory.buildObjective(Context.EvaluationPhases.LEARNING, strategy.getConfiguration());
        for (int i = 0; i < population.size(); ++i) {
            Ranking individual = population.get(i);
            FinalSolution finalSolution = new FinalSolution(individual);
            if (i == 0) {
                double[] trainingPerformace = trainingObjective.fitness(individual.getTree());
                double[] validationPerformance = validationObjective.fitness(individual.getTree());
                double[] learningPerformance = learningObjective.fitness(individual.getTree());
                PerformacesObjective.populatePerformancesMap(trainingPerformace, finalSolution.getTrainingPerformances());
                PerformacesObjective.populatePerformancesMap(validationPerformance, finalSolution.getValidationPerformances());
                PerformacesObjective.populatePerformancesMap(learningPerformance, finalSolution.getLearningPerformances());
            }
            jobTrace.getFinalGeneration().add(finalSolution);
        }
        if (this.status.jobDone >= strategy.getConfiguration().getJobs() && this.callPostProcessorAutomatically) {
            this.callPostProcessor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evolutionFailed(RunStrategy strategy, TreeEvaluationException cause) {
        int jobId = strategy.getConfiguration().getJobId();
        NavigableSet<Integer> navigableSet = this.remove;
        synchronized (navigableSet) {
            this.remove.add(jobId);
        }
        ++this.status.jobDone;
        ++this.status.jobFailed;
        if (this.status.jobDone >= strategy.getConfiguration().getJobs() && this.callPostProcessorAutomatically) {
            this.callPostProcessor();
        }
        LOG.log(Level.SEVERE, "Job " + jobId + " failed", cause);
    }

    private void callPostProcessor() {
        if (this.configuration.getPostProcessor() != null) {
            long elaborationTime = System.currentTimeMillis() - this.startTime;
            this.configuration.getPostProcessor().elaborate(this.configuration, this.results, elaborationTime);
        }
        this.status.isSearchRunning = false;
        this.status.best = this.results.getBestSolution();
        this.status.hasFinalResult = true;
    }

    @Override
    public void register(ExecutionStrategy strategy) {
    }

    @Override
    public ExecutionListener getNewListener() {
        return this;
    }

    public BasicExecutionStatus getStatus() {
        return this.status;
    }

    public Results getResults() {
        return this.results;
    }

    public List<List<DataSet.Bounds>> getBestEvaluations() throws TreeEvaluationException {
        TreeEvaluator treeEvaluator = this.configuration.getEvaluator();
        Constant bestIndividualReplica = new Constant(this.status.best.getSolution());
        return treeEvaluator.evaluate(bestIndividualReplica, new Context(Context.EvaluationPhases.LEARNING, this.configuration));
    }

    public List<BasicStats> getBestEvaluationStats(int startIndex, int endIndex) throws TreeEvaluationException {
        List<List<DataSet.Bounds>> bestevaluations = this.getBestEvaluations();
        DataSet dataset = this.configuration.getDatasetContainer().getLearningDataset();
        LinkedList<BasicStats> statsPerExample = new LinkedList<BasicStats>();
        for (int index = startIndex; index <= endIndex; ++index) {
            List<DataSet.Bounds> extractionsList = bestevaluations.get(index);
            HashSet<DataSet.Bounds> extractionsSet = new HashSet<DataSet.Bounds>(extractionsList);
            DataSet.Example example = dataset.getExample(index);
            extractionsSet.removeAll(example.getMatch());
            BasicStats exampleStats = new BasicStats();
            exampleStats.fn = -1L;
            exampleStats.fp = extractionsSet.size();
            exampleStats.tp = (long)extractionsList.size() - exampleStats.fp;
            exampleStats.tn = -1L;
            statsPerExample.add(exampleStats);
        }
        return statsPerExample;
    }

    @Override
    public void evolutionStopped() {
        this.status.isSearchRunning = false;
    }
}

