/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.utils.Range;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public final class DatasetContainer {
    private String path;
    private transient DataSet dataset;
    private List<Range> training = new ArrayList<Range>();
    private List<Range> validation = new ArrayList<Range>();
    private boolean dataSetStriped = false;
    private double datasetStripeMarginSize = 2.147483647E9;
    private int normalProposedDatasetInterval = 0;
    private transient DataSet trainingDataset;
    private transient DataSet validationDataset;
    private transient DataSet learningDataset;

    public DatasetContainer() {
    }

    public DatasetContainer(DatasetContainer datasetContainer) {
        this.path = datasetContainer.getPath();
        this.dataset = datasetContainer.getDataset();
        this.training = new LinkedList<Range>(datasetContainer.getTraining());
        this.validation = new LinkedList<Range>(datasetContainer.getValidation());
        this.dataSetStriped = datasetContainer.isDataSetStriped();
        this.datasetStripeMarginSize = datasetContainer.getDatasetStripeMarginSize();
        this.normalProposedDatasetInterval = datasetContainer.getProposedNormalDatasetInterval();
        this.trainingDataset = datasetContainer.getTrainingDataset();
        this.validationDataset = datasetContainer.getValidationDataset();
        this.learningDataset = datasetContainer.getLearningDataset();
    }

    public DatasetContainer(DataSet dataset) {
        this(dataset, false, 0);
    }

    public DatasetContainer(DataSet dataset, boolean defaultRanges) {
        this(dataset, defaultRanges, 0);
    }

    public DatasetContainer(DataSet dataset, boolean defaultRanges, int defaultRangesSeed) {
        this();
        this.setDataset(dataset);
        this.dataset.populateAnnotatedStrings();
        this.dataset.updateStats();
        if (defaultRanges) {
            this.createDefaultRanges(defaultRangesSeed);
            this.updateSubDataset();
        }
    }

    public void createDefaultRanges(int randomSeed) {
        this.training.clear();
        this.validation.clear();
        Random random = new Random(randomSeed);
        int overallNumberMatchesInTraining = (int)Math.ceil((double)this.dataset.getNumberMatches() / 2.0);
        int matchesInTrainingCountdown = overallNumberMatchesInTraining = overallNumberMatchesInTraining == 0 ? 1 : overallNumberMatchesInTraining;
        ArrayList<Integer> examplePositiveIndexes = new ArrayList<Integer>();
        ArrayList<Integer> exampleNegativeIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.dataset.getNumberExamples(); ++i) {
            DataSet.Example example = this.dataset.getExamples().get(i);
            if (example.getNumberMatches() > 0) {
                examplePositiveIndexes.add(i);
                continue;
            }
            exampleNegativeIndexes.add(i);
        }
        Collections.shuffle(examplePositiveIndexes, random);
        Collections.shuffle(exampleNegativeIndexes, random);
        for (Integer exampleIndex : examplePositiveIndexes) {
            DataSet.Example example = this.dataset.getExamples().get(exampleIndex);
            if (examplePositiveIndexes.size() == 1 || matchesInTrainingCountdown > 0 && (!this.validation.isEmpty() || example.getNumberMatches() >= overallNumberMatchesInTraining)) {
                this.training.add(new Range(exampleIndex, exampleIndex));
                matchesInTrainingCountdown -= example.getNumberMatches();
                continue;
            }
            this.validation.add(new Range(exampleIndex, exampleIndex));
        }
        for (int i = 0; i < exampleNegativeIndexes.size(); ++i) {
            if ((double)i < Math.ceil((double)exampleNegativeIndexes.size() / 2.0)) {
                this.training.add(new Range((Integer)exampleNegativeIndexes.get(i), (Integer)exampleNegativeIndexes.get(i)));
                continue;
            }
            this.validation.add(new Range((Integer)exampleNegativeIndexes.get(i), (Integer)exampleNegativeIndexes.get(i)));
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) throws IOException {
        this.path = path;
        this.loadDataset();
    }

    public List<Range> getTraining() {
        return this.training;
    }

    public void setTraining(List<Range> training) {
        this.training = training;
    }

    public List<Range> getValidation() {
        return this.validation;
    }

    public void setValidation(List<Range> validation) {
        this.validation = validation;
    }

    public boolean isDataSetStriped() {
        return this.dataSetStriped;
    }

    public void setDataSetsStriped(boolean datasetStriped) {
        this.dataSetStriped = datasetStriped;
    }

    public int getProposedNormalDatasetInterval() {
        return this.normalProposedDatasetInterval;
    }

    public void setProposedNormalDatasetInterval(int unstripedDatasetInterval) {
        this.normalProposedDatasetInterval = unstripedDatasetInterval;
    }

    public DataSet getDataset() {
        return this.dataset;
    }

    public final void setDataset(DataSet dataset) {
        this.dataset = dataset;
    }

    public DataSet getTrainingDataset() {
        return this.trainingDataset;
    }

    public void setTrainingDataset(DataSet trainingDataset) {
        this.trainingDataset = trainingDataset;
    }

    public DataSet getValidationDataset() {
        return this.validationDataset;
    }

    public void setValidationDataset(DataSet validationDataset) {
        this.validationDataset = validationDataset;
    }

    public DataSet getLearningDataset() {
        return this.learningDataset;
    }

    public double getDatasetStripeMarginSize() {
        return this.datasetStripeMarginSize;
    }

    public void setDatasetStripeMarginSize(double datasetStripeMarginSize) {
        this.datasetStripeMarginSize = datasetStripeMarginSize;
    }

    public void loadDataset() throws IOException {
        StringBuilder sb;
        FileInputStream fis = new FileInputStream(new File(this.path));
        InputStreamReader isr = new InputStreamReader(fis);
        try (BufferedReader bufferedReader = new BufferedReader(isr);){
            String line;
            sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
        }
        String json = sb.toString();
        this.loadDatasetJson(json);
    }

    public void loadDatasetJson(String jsonDataset) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        this.dataset = gson.fromJson(jsonDataset, DataSet.class);
        this.update();
    }

    public final void updateSubDataset() {
        this.trainingDataset = this.dataset.subDataset("training", this.training);
        this.validationDataset = this.dataset.subDataset("validation", this.validation);
        this.trainingDataset.updateStats();
        this.validationDataset.updateStats();
        this.learningDataset = new DataSet("learning");
        this.learningDataset.getExamples().addAll(this.dataset.getExamples());
        this.learningDataset.updateStats();
        if (this.dataSetStriped) {
            this.trainingDataset.initStripedDatasetView(this.datasetStripeMarginSize);
            this.trainingDataset.getStripedDataset().updateStats();
        }
    }

    public void update() {
        this.dataset.populateAnnotatedStrings();
        this.dataset.updateStats();
        this.updateSubDataset();
    }
}

