/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.generations;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.generations.InitialPopulationBuilder;
import it.units.inginf.male.generations.TokenizedPopulationBuilder;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.terminalsets.TokenizedContextTerminalSetBuilder;
import it.units.inginf.male.tree.AbstractNode;
import it.units.inginf.male.tree.Constant;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.tree.RegexRange;
import it.units.inginf.male.tree.operator.Concatenator;
import it.units.inginf.male.tree.operator.ListMatch;
import it.units.inginf.male.tree.operator.MatchMinMax;
import it.units.inginf.male.tree.operator.MatchOneOrMore;
import it.units.inginf.male.tree.operator.PositiveLookahead;
import it.units.inginf.male.tree.operator.PositiveLookbehind;
import it.units.inginf.male.utils.BasicTokenizer;
import it.units.inginf.male.utils.Tokenizer;
import it.units.inginf.male.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class TokenizedContextPopulationBuilder
implements InitialPopulationBuilder {
    private List<Node> population = new LinkedList<Node>();
    private Map<String, Double> winnerMatchTokens;
    private Map<String, Double> winnerUnMatchTokens;
    private Tokenizer tokenizer = new BasicTokenizer();

    @Override
    public List<Node> init() {
        return new ArrayList<Node>(this.population);
    }

    @Override
    public void setup(Configuration configuration) {
        DataSet trainingDataset = configuration.getDatasetContainer().getTrainingDataset();
        this.population.addAll(this.setup(null, configuration, trainingDataset));
    }

    private List<Node> setup(Context context, Configuration configuration, DataSet usedTrainingDataset) {
        Map<String, String> parameters;
        Double TOKEN_THREASHOLD = 80.0;
        Double TOKEN_UNMATCH_THREASHOLD = 80.0;
        boolean ADD_NO_CONTEXT_INDIVIDUALS = true;
        boolean DISCARD_W_TOKENS = true;
        if (usedTrainingDataset.getStripedDataset() != null) {
            usedTrainingDataset = usedTrainingDataset.getStripedDataset();
        }
        if ((parameters = configuration.getPopulationBuilderParameters()) != null) {
            if (parameters.containsKey("tokenThreashold")) {
                TOKEN_THREASHOLD = Double.valueOf(parameters.get("tokenThreashold"));
            }
            if (parameters.containsKey("discardWtokens")) {
                DISCARD_W_TOKENS = Boolean.valueOf(parameters.get("discardWtokens"));
            }
            if (parameters.containsKey("tokenUnmatchThreashold")) {
                TOKEN_UNMATCH_THREASHOLD = Double.valueOf(parameters.get("tokenUnmatchThreashold"));
            }
            if (parameters.containsKey("addNoContextIndividuals")) {
                ADD_NO_CONTEXT_INDIVIDUALS = Boolean.valueOf(parameters.get("addNoContextIndividuals"));
            }
        }
        LinkedList<Node> newPopulation = new LinkedList<Node>();
        this.winnerMatchTokens = TokenizedContextTerminalSetBuilder.calculateWinnerMatchTokens(usedTrainingDataset, TOKEN_THREASHOLD, DISCARD_W_TOKENS);
        this.winnerUnMatchTokens = TokenizedContextTerminalSetBuilder.calculateWinnerUnmatchTokens(usedTrainingDataset, TOKEN_UNMATCH_THREASHOLD, DISCARD_W_TOKENS);
        for (DataSet.Example example : usedTrainingDataset.getExamples()) {
            if (example.getMatch().isEmpty()) continue;
            newPopulation.addAll(this.createIndividualsFromExample(example, true, this.winnerMatchTokens, this.winnerUnMatchTokens));
            newPopulation.addAll(this.createIndividualsFromExample(example, false, this.winnerMatchTokens, this.winnerUnMatchTokens));
        }
        if (ADD_NO_CONTEXT_INDIVIDUALS) {
            TokenizedPopulationBuilder tokenizedPopulationBuilder = new TokenizedPopulationBuilder();
            if (context == null) {
                tokenizedPopulationBuilder.setup(configuration);
                newPopulation.addAll(tokenizedPopulationBuilder.init());
            } else {
                newPopulation.addAll(tokenizedPopulationBuilder.init(context));
            }
        }
        int popSize = Math.min(configuration.getEvolutionParameters().getPopulationSize() / 2, newPopulation.size());
        Collections.shuffle(newPopulation, new Random(0L));
        newPopulation = new LinkedList(newPopulation.subList(0, popSize));
        return newPopulation;
    }

    private List<Node> createIndividualsFromExample(DataSet.Example example, boolean compact, Map<String, Double> winnerMatchTokens, Map<String, Double> winnerUnMatchTokens) {
        if (example.getNumberMatches() == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Node> individualsForExample = new LinkedList<Node>();
        HashSet<String> matchSet = new HashSet<String>(example.getMatchedStrings());
        HashSet<String> unmatchSet = new HashSet<String>(example.getUnmatchedStrings());
        List<String> orderedAnnotatedStrings = example.getOrderedAnnotatedStrings();
        String pre = null;
        String match = null;
        String post = null;
        for (int i = 0; i < orderedAnnotatedStrings.size(); ++i) {
            if (!matchSet.contains(orderedAnnotatedStrings.get(i))) continue;
            match = orderedAnnotatedStrings.get(i);
            if (i > 0 && unmatchSet.contains(orderedAnnotatedStrings.get(i - 1))) {
                pre = orderedAnnotatedStrings.get(i - 1);
            }
            if (i + 1 < orderedAnnotatedStrings.size() && unmatchSet.contains(orderedAnnotatedStrings.get(i + 1))) {
                post = orderedAnnotatedStrings.get(i + 1);
            }
            individualsForExample.add(this.createIndividualFromStrings(pre, match, post, compact, winnerMatchTokens, winnerUnMatchTokens));
        }
        return individualsForExample;
    }

    private Node createIndividualFromStrings(String preUnmatchString, String matchString, String postUnmatchString, boolean compact, Map<String, Double> winnerMatchTokens, Map<String, Double> winnerUnmatchTokens) {
        Concatenator finalIndividualTemp;
        Node preUnmatchNode = null;
        Node matchNode = null;
        Node postUnmatchNode = null;
        if (preUnmatchString != null) {
            List<String> preUnmatchStringTokens = this.tokenizer.tokenize(preUnmatchString);
            preUnmatchNode = this.createIndividualFromTokenizedString(preUnmatchStringTokens, winnerUnmatchTokens, compact, true);
        }
        if (matchString != null) {
            List<String> matchStringTokens = this.tokenizer.tokenize(matchString);
            matchNode = this.createIndividualFromTokenizedString(matchStringTokens, winnerMatchTokens, compact, false);
        }
        if (postUnmatchString != null) {
            List<String> postUnmatchStringTokens = this.tokenizer.tokenize(postUnmatchString);
            postUnmatchNode = this.createIndividualFromTokenizedString(postUnmatchStringTokens, winnerUnmatchTokens, compact, false);
        }
        Node finalIndividual = matchNode;
        if (postUnmatchNode != null) {
            finalIndividualTemp = new Concatenator();
            finalIndividualTemp.getChildrens().add(matchNode);
            PositiveLookahead positiveLookAhead = new PositiveLookahead();
            positiveLookAhead.getChildrens().add(postUnmatchNode);
            finalIndividualTemp.getChildrens().add(positiveLookAhead);
            finalIndividual = finalIndividualTemp;
        }
        if (preUnmatchNode != null) {
            finalIndividualTemp = new Concatenator();
            PositiveLookbehind positiveLookBehind = new PositiveLookbehind();
            positiveLookBehind.getChildrens().add(preUnmatchNode);
            finalIndividualTemp.getChildrens().add(positiveLookBehind);
            finalIndividualTemp.getChildrens().add(finalIndividual);
            finalIndividual = finalIndividualTemp;
        }
        return finalIndividual;
    }

    private Node createIndividualFromTokenizedString(List<String> tokenizedString, Map<String, Double> winnerTokens, boolean compact, boolean useMinMaxQuantifier) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        LinkedList<Node> tmp = new LinkedList<Node>();
        String w = "\\w";
        String d = "\\d";
        ListMatch letters = new ListMatch();
        letters.getChildrens().add(new RegexRange("A-Za-z"));
        for (String token : tokenizedString) {
            if (winnerTokens.containsKey(token)) {
                nodes.add(new Constant(Utils.escape(token)));
                continue;
            }
            for (char c : token.toCharArray()) {
                if (Character.isLetter(c)) {
                    nodes.add(letters.cloneTree());
                    continue;
                }
                if (Character.isDigit(c)) {
                    nodes.add(new Constant(d));
                    continue;
                }
                nodes.add(new Constant(Utils.escape(c)));
            }
        }
        if (compact) {
            LinkedList<Node> newNodes = new LinkedList<Node>();
            while (nodes.size() > 0) {
                Node next;
                String nextValue;
                Node node = (Node)nodes.pollFirst();
                String nodeValue = node.toString();
                boolean isRepeat = false;
                int repetitions = 1;
                while (nodes.size() > 0 && nodeValue.equals(nextValue = (next = (Node)nodes.peek()).toString())) {
                    ++repetitions;
                    isRepeat = true;
                    nodes.pollFirst();
                }
                if (isRepeat) {
                    AbstractNode finalNode = null;
                    if (useMinMaxQuantifier) {
                        finalNode = new MatchMinMax();
                        finalNode.getChildrens().add(node);
                        finalNode.getChildrens().add(new Constant("1"));
                        finalNode.getChildrens().add(new Constant(String.valueOf(repetitions)));
                    } else {
                        finalNode = new MatchOneOrMore();
                        finalNode.getChildrens().add(node);
                    }
                    node = finalNode;
                }
                newNodes.add(node);
            }
            nodes = newNodes;
        }
        while (nodes.size() > 1) {
            while (nodes.size() > 0) {
                Node first = (Node)nodes.pollFirst();
                Node second = (Node)nodes.pollFirst();
                if (second != null) {
                    Concatenator conc = new Concatenator();
                    conc.getChildrens().add(first);
                    conc.getChildrens().add(second);
                    first.setParent(conc);
                    second.setParent(conc);
                    tmp.addLast(conc);
                    continue;
                }
                tmp.addLast(first);
            }
            nodes = tmp;
            tmp = new LinkedList();
        }
        return (Node)nodes.getFirst();
    }

    @Override
    public List<Node> init(Context context) {
        return this.setup(context, context.getConfiguration(), context.getCurrentDataSet());
    }
}

