/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.inputs;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.configuration.DatasetContainer;
import it.units.inginf.male.inputs.DataSet;
import java.util.Random;

public class Context {
    private EvaluationPhases phase;
    private boolean stripedPhase = false;
    private boolean separateAndConquerEnabled = false;
    private Random random;
    private Configuration configuration;
    private long seed;

    public Context(EvaluationPhases phase, Configuration configuration) {
        this.phase = phase;
        this.configuration = configuration;
        this.seed = configuration.getInitialSeed();
        this.random = new Random(this.seed);
    }

    public boolean isStripedPhase() {
        return this.stripedPhase;
    }

    public void setStripedPhase(boolean stripedPhase) {
        this.stripedPhase = stripedPhase;
    }

    public Random getRandom() {
        return this.random;
    }

    public EvaluationPhases getPhase() {
        return this.phase;
    }

    public void setPhase(EvaluationPhases phase) {
        this.phase = phase;
    }

    public int getCurrentDataSetLength() {
        return this.getCurrentDataSet().getNumberExamples();
    }

    public long getSeed() {
        return this.seed;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public DatasetContainer getDataSetContainer() {
        return this.configuration.getDatasetContainer();
    }

    public DataSet getCurrentDataSet() {
        switch (this.phase) {
            case TRAINING: {
                DataSet trainingDataset = !this.isStripedPhase() ? this.getDataSetContainer().getTrainingDataset() : this.getDataSetContainer().getTrainingDataset().getStripedDataset();
                if (this.separateAndConquerEnabled) {
                    return trainingDataset.getLastSeparateAndConquerDataSet((int)this.getSeed());
                }
                return trainingDataset;
            }
            case VALIDATION: {
                return this.getDataSetContainer().getValidationDataset();
            }
            case LEARNING: {
                return this.getDataSetContainer().getLearningDataset();
            }
        }
        throw new UnsupportedOperationException("unhandled phase in getDataSet");
    }

    public String toString() {
        return this.phase.toString();
    }

    public boolean isSeparateAndConquerEnabled() {
        return this.separateAndConquerEnabled;
    }

    public DataSet getTrainingDataset() {
        return this.configuration.getDatasetContainer().getTrainingDataset();
    }

    public void setSeparateAndConquerEnabled(boolean separateAndConquerEnabled) {
        this.separateAndConquerEnabled = separateAndConquerEnabled;
    }

    public static enum EvaluationPhases {
        TRAINING,
        VALIDATION,
        LEARNING;

    }
}

