/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.selections.best;

import it.units.inginf.male.outputs.FinalSolution;
import it.units.inginf.male.outputs.JobEvolutionTrace;
import it.units.inginf.male.outputs.Results;
import it.units.inginf.male.selections.best.BestSelector;
import java.util.Map;
import java.util.logging.Logger;

public class BasicLearningBestSelector
implements BestSelector {
    private static Logger LOG = Logger.getLogger(BasicLearningBestSelector.class.getName());

    @Override
    public void setup(Map<String, String> parameters) {
    }

    @Override
    public void elaborate(Results results) {
        this.selectAndPopulateBest(results);
    }

    private void selectAndPopulateBest(Results results) {
        double bestIndividualIndex = Double.NEGATIVE_INFINITY;
        int bestLength = Integer.MAX_VALUE;
        FinalSolution best = null;
        for (JobEvolutionTrace jobEvolutionTrace : results.getJobEvolutionTraces()) {
            FinalSolution bestOfJob = jobEvolutionTrace.getFinalGeneration().get(0);
            double precision = bestOfJob.getLearningPerformances().get("match precision");
            double recall = bestOfJob.getLearningPerformances().get("match recall");
            int bestJobLength = bestOfJob.getSolution().length();
            double individualIndex = ((precision = Double.isNaN(precision) ? 0.0 : precision) + (recall = Double.isNaN(recall) ? 0.0 : recall)) / 2.0;
            if (!(individualIndex > bestIndividualIndex) && (individualIndex != bestIndividualIndex || bestLength <= bestJobLength)) continue;
            bestLength = bestJobLength;
            best = bestOfJob;
            bestIndividualIndex = individualIndex;
        }
        results.setBestSolution(best);
    }
}

