/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.strategy.impl;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.strategy.ExecutionListener;
import it.units.inginf.male.strategy.ExecutionListenerFactory;
import it.units.inginf.male.strategy.RunStrategy;
import it.units.inginf.male.strategy.impl.AbstractExecutionStrategy;
import it.units.inginf.male.strategy.impl.DefaultStrategy;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CombinedMultithreadStrategy
extends AbstractExecutionStrategy {
    public static final String RUN_ALT_STRATEGY_KEY = "runStrategy2";
    public static final String RUN_ALT_FITNESS_KEY = "objective2";
    public static final String RUN_ALT_TERMINATION_CRITERIA_KEY = "terminationCriteria2";
    public static final String THREADS_KEY = "threads";
    private static final Logger LOG = Logger.getLogger(CombinedMultithreadStrategy.class.getName());
    ExecutorService executor;
    private volatile Thread workingThread = null;
    private volatile boolean terminated = false;

    private int countThreads(Map<String, String> parameters) {
        int threads;
        String paramValue = parameters.get(THREADS_KEY);
        try {
            threads = Integer.parseInt(paramValue);
        }
        catch (NumberFormatException x) {
            threads = Runtime.getRuntime().availableProcessors();
            LOG.log(Level.WARNING, "Falling back to default threads count: {0}", threads);
        }
        return threads;
    }

    @Override
    public void execute(Configuration configuration, ExecutionListenerFactory listenerFactory) throws Exception {
        Class<? extends RunStrategy> strategyClass;
        this.workingThread = Thread.currentThread();
        listenerFactory.register(this);
        Map<String, String> parameters = configuration.getStrategyParameters();
        int threads = this.countThreads(parameters);
        Class<? extends RunStrategy> altStrategyClass = strategyClass = this.getStrategy(parameters);
        String altFitnessClassName = null;
        this.executor = Executors.newFixedThreadPool(threads);
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(this.executor);
        long initialSeed = configuration.getInitialSeed();
        int jobs = configuration.getJobs();
        int changejobs = jobs + 1;
        if (parameters.containsKey(RUN_ALT_STRATEGY_KEY)) {
            altStrategyClass = this.getAlternativeStrategy(parameters);
            changejobs = jobs / 2;
        }
        if (parameters.containsKey(RUN_ALT_FITNESS_KEY)) {
            altFitnessClassName = this.getAlternativeFitness(parameters);
        }
        for (int i = 0; i < jobs; ++i) {
            RunStrategy job;
            Configuration jobConf = new Configuration(configuration);
            if (i < changejobs) {
                job = strategyClass.newInstance();
            } else {
                this.activeAlternativeParameter(RUN_ALT_TERMINATION_CRITERIA_KEY, jobConf.getStrategyParameters());
                if (altFitnessClassName != null) {
                    jobConf.updateObjective(altFitnessClassName);
                }
                job = altStrategyClass.newInstance();
            }
            jobConf.setJobId(i);
            jobConf.setInitialSeed(initialSeed + (long)i);
            job.setup(jobConf, listenerFactory.getNewListener());
            completionService.submit(job);
        }
        this.executor.shutdown();
        ExecutionListener listener = listenerFactory.getNewListener();
        for (int i = 0; i < jobs; ++i) {
            Future result = null;
            try {
                if (this.terminated) {
                    if (listener != null) {
                        listener.evolutionStopped();
                    }
                    return;
                }
                result = completionService.take();
            }
            catch (InterruptedException ex) {
                if (listener != null) {
                    listener.evolutionStopped();
                }
                return;
            }
            try {
                result.get();
                continue;
            }
            catch (ExecutionException x) {
                if (!(x.getCause() instanceof TreeEvaluationException)) continue;
                TreeEvaluationException ex = (TreeEvaluationException)x.getCause();
                RunStrategy strategy = ex.getAssociatedStrategy();
                LOG.log(Level.SEVERE, "Job " + strategy.getConfiguration().getJobId() + " failed with exception", ex.getCause());
                if (listener == null) continue;
                listener.evolutionFailed(strategy, ex);
            }
        }
    }

    @Override
    public void shutdown() {
        this.executor.shutdownNow();
        if (this.workingThread != null) {
            this.terminated = true;
            this.workingThread.interrupt();
        }
    }

    protected Class<? extends RunStrategy> getAlternativeStrategy(Map<String, String> parameters) {
        Class<RunStrategy> strategyClass;
        String paramValue = parameters.get(RUN_ALT_STRATEGY_KEY);
        try {
            strategyClass = Class.forName(paramValue).asSubclass(RunStrategy.class);
        }
        catch (Exception x) {
            LOG.warning("Falling back to default RunStrategy");
            strategyClass = DefaultStrategy.class;
        }
        return strategyClass;
    }

    private String getAlternativeFitness(Map<String, String> parameters) {
        String paramValue = parameters.get(RUN_ALT_FITNESS_KEY);
        return paramValue;
    }

    private void activeAlternativeParameter(String parameterAlternativeName, Map<String, String> parametersMap) {
        if (!parametersMap.containsKey(parameterAlternativeName)) {
            LOG.warning("Invalid parameterAlternativeName provided to activeAlternaveParameter method");
            return;
        }
        String alternativeValue = parametersMap.get(parameterAlternativeName);
        String parameterOriginalName = parameterAlternativeName.substring(0, parameterAlternativeName.length() - 1);
        parametersMap.put(parameterOriginalName, alternativeValue);
    }
}

