/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.strategy.impl;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.generations.Ramped;
import it.units.inginf.male.objective.Ranking;
import it.units.inginf.male.strategy.impl.DefaultStrategy;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.utils.Pair;
import it.units.inginf.male.utils.UniqueList;
import it.units.inginf.male.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DiversityElitarismStrategy
extends DefaultStrategy {
    boolean deepDiversity = false;

    @Override
    protected void readParameters(Configuration configuration) {
        super.readParameters(configuration);
        Map<String, String> parameters = configuration.getStrategyParameters();
        if (parameters != null && parameters.containsKey("deepDiversity")) {
            this.deepDiversity = Boolean.valueOf(parameters.get("deepDiversity"));
        }
    }

    @Override
    protected void evolve() {
        int stepPopSize;
        int popSize = this.population.size();
        int oldPopSize = (int)((double)popSize * 0.9);
        UniqueList<Node> newPopulation = new UniqueList<Node>(popSize);
        if (this.deepDiversity) {
            newPopulation.addAll((Collection<Node>)this.population);
        }
        boolean allPerfect = true;
        for (double fitness : ((Ranking)this.rankings.get(0)).getFitness()) {
            if (Math.round(fitness * 10000.0) == 0L) continue;
            allPerfect = false;
            break;
        }
        if (allPerfect) {
            return;
        }
        int n = stepPopSize = this.deepDiversity ? popSize + oldPopSize : oldPopSize;
        while (newPopulation.size() < stepPopSize) {
            double random = this.context.getRandom().nextDouble();
            if (random <= (double)this.param.getCrossoverProbability() && oldPopSize - newPopulation.size() >= 2) {
                Node selectedB;
                Node selectedA = this.selection.select(this.rankings);
                Pair<Node, Node> newIndividuals = this.variation.crossover(selectedA, selectedB = this.selection.select(this.rankings));
                if (newIndividuals == null) continue;
                newPopulation.add(newIndividuals.getFirst());
                newPopulation.add(newIndividuals.getSecond());
                continue;
            }
            if (random <= (double)(this.param.getCrossoverProbability() + this.param.getMutationPobability())) {
                Node mutant = this.selection.select(this.rankings);
                mutant = this.variation.mutate(mutant);
                newPopulation.add(mutant);
                continue;
            }
            Node duplicated = this.selection.select(this.rankings);
            newPopulation.add(duplicated);
        }
        Ramped ramped = new Ramped(this.maxDepth, this.context);
        List<Node> generated = ramped.generate(popSize - oldPopSize);
        newPopulation.addAll((Collection<Node>)generated);
        if (!this.deepDiversity) {
            newPopulation.addAll((Collection<Node>)this.population);
        }
        List<Ranking> tmp = this.buildRankings(newPopulation, this.objective);
        this.rankings.clear();
        while (tmp.size() > 0) {
            List<Ranking> t = Utils.getFirstParetoFront(tmp);
            tmp.removeAll(t);
            this.sortByFirst(t);
            this.rankings.addAll(t);
        }
        this.rankings = new ArrayList(this.rankings.subList(0, popSize));
        this.population.clear();
        for (Ranking r : this.rankings) {
            this.population.add(r.getTree());
        }
    }
}

