/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.strategy.impl;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.generations.InitialPopulationBuilder;
import it.units.inginf.male.generations.Ramped;
import it.units.inginf.male.objective.Ranking;
import it.units.inginf.male.objective.performance.PerformacesObjective;
import it.units.inginf.male.strategy.impl.DiversityElitarismStrategy;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.tree.operator.Or;
import it.units.inginf.male.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SeparateAndConquerStrategy
extends DiversityElitarismStrategy {
    private boolean convertToUnmatch = true;
    private boolean isFlagging = false;

    @Override
    protected void readParameters(Configuration configuration) {
        super.readParameters(configuration);
        Map<String, String> parameters = configuration.getStrategyParameters();
        if (parameters != null) {
            if (parameters.containsKey("convertToUnmatch")) {
                this.convertToUnmatch = Boolean.valueOf(parameters.get("convertToUnmatch"));
            }
            if (parameters.containsKey("isFlagging")) {
                this.isFlagging = Boolean.valueOf(parameters.get("isFlagging"));
            }
        }
    }

    private void initialize() {
        int targetPopSize = this.param.getPopulationSize();
        this.rankings.clear();
        InitialPopulationBuilder populationBuilder = this.context.getConfiguration().getPopulationBuilder();
        this.population = populationBuilder.init(this.context);
        this.context.getConfiguration().getTerminalSetBuilder().setup(this.context);
        Ramped ramped = new Ramped(this.maxDepth, this.context);
        this.population.addAll(ramped.generate(targetPopSize - this.population.size()));
        List<Ranking> tmp = this.buildRankings(this.population, this.objective);
        while (tmp.size() > 0) {
            List<Ranking> t = Utils.getFirstParetoFront(tmp);
            tmp.removeAll(t);
            this.sortByFirst(t);
            this.rankings.addAll(t);
        }
    }

    @Override
    public Void call() throws TreeEvaluationException {
        try {
            LinkedList<Node> tmpBests;
            int generation;
            this.listener.evolutionStarted(this);
            this.initialize();
            LinkedList<Node> bests = new LinkedList<Node>();
            String oldGenerationBestValue = null;
            int terminationCriteriaGenerationsCounter = 0;
            this.context.setSeparateAndConquerEnabled(true);
            for (generation = 0; generation < this.param.getGenerations(); ++generation) {
                this.context.setStripedPhase(this.context.getDataSetContainer().isDataSetStriped() && generation % this.context.getDataSetContainer().getProposedNormalDatasetInterval() != 0);
                this.evolve();
                Ranking best = (Ranking)this.rankings.get(0);
                tmpBests = new LinkedList<Node>(bests);
                tmpBests.add(best.getTree());
                Node joinedBest = this.joinSolutions(tmpBests);
                this.context.setSeparateAndConquerEnabled(false);
                double[] fitnessOfJoined = this.objective.fitness(joinedBest);
                this.context.setSeparateAndConquerEnabled(true);
                if (this.listener != null) {
                    this.listener.logGeneration(this, generation + 1, joinedBest, fitnessOfJoined, this.rankings);
                }
                boolean allPerfect = true;
                for (double fitness : ((Ranking)this.rankings.get(0)).getFitness()) {
                    if (Math.round(fitness * 10000.0) == 0L) continue;
                    allPerfect = false;
                    break;
                }
                if (allPerfect) break;
                PerformacesObjective trainingObjective = new PerformacesObjective();
                trainingObjective.setup(this.context);
                double[] trainingPerformace = trainingObjective.fitness(best.getTree());
                HashMap<String, Double> performancesMap = new HashMap<String, Double>();
                PerformacesObjective.populatePerformancesMap(trainingPerformace, performancesMap);
                double pr = (Double)performancesMap.get("match precision");
                double re = (Double)performancesMap.get("match recall");
                String newBestValue = best.getDescription();
                terminationCriteriaGenerationsCounter = newBestValue.equals(oldGenerationBestValue) ? ++terminationCriteriaGenerationsCounter : 0;
                oldGenerationBestValue = newBestValue;
                if (terminationCriteriaGenerationsCounter >= this.terminationCriteriaGenerations && pr == 1.0 && generation < this.param.getGenerations() - 1) {
                    terminationCriteriaGenerationsCounter = 0;
                    bests.add(((Ranking)this.rankings.get(0)).getTree());
                    StringBuilder builder = new StringBuilder();
                    ((Ranking)this.rankings.get(0)).getTree().describe(builder);
                    this.context.getTrainingDataset().addSeparateAndConquerLevel(builder.toString(), (int)this.context.getSeed(), this.convertToUnmatch, this.isFlagging);
                    if (this.context.getCurrentDataSet().getNumberMatches() == 0) {
                        this.context.getTrainingDataset().removeSeparateAndConquerLevel((int)this.context.getSeed());
                        break;
                    }
                    this.initialize();
                }
                if (Thread.interrupted()) break;
            }
            if (!bests.contains(((Ranking)this.rankings.get(0)).getTree())) {
                bests.add(((Ranking)this.rankings.get(0)).getTree());
            }
            if (this.listener != null) {
                ArrayList<Node> dividedPopulation = new ArrayList<Node>(this.population.size());
                tmpBests = new LinkedList(bests);
                for (Ranking r : this.rankings) {
                    tmpBests.set(tmpBests.size() - 1, r.getTree());
                    dividedPopulation.add(this.joinSolutions(tmpBests));
                }
                this.context.setSeparateAndConquerEnabled(false);
                List<Ranking> tmp = this.buildRankings(dividedPopulation, this.objective);
                this.listener.evolutionComplete(this, generation - 1, tmp);
            }
            return null;
        }
        catch (Throwable x) {
            throw new TreeEvaluationException("Error during evaluation of a tree", x, this);
        }
    }

    @Override
    protected void sortByFirst(List<Ranking> front) {
        Collections.sort(front, new Comparator<Ranking>(){

            @Override
            public int compare(Ranking o1, Ranking o2) {
                double[] fitness1 = o1.getFitness();
                double[] fitness2 = o2.getFitness();
                int compare = 0;
                for (int i = 0; i < fitness1.length; ++i) {
                    compare = Double.compare(fitness1[i], fitness2[i]);
                    if (compare == 0) continue;
                    return compare;
                }
                return -o1.getDescription().compareTo(o2.getDescription());
            }
        });
    }

    private Node joinSolutions(List<Node> bests) {
        LinkedList<Node> nodes = new LinkedList<Node>(bests);
        LinkedList<Node> tmp = new LinkedList<Node>();
        while (nodes.size() > 1) {
            while (nodes.size() > 0) {
                Node first = (Node)nodes.pollFirst();
                Node second = (Node)nodes.pollFirst();
                if (second != null) {
                    Or or = new Or();
                    or.getChildrens().add(first);
                    or.getChildrens().add(second);
                    first.setParent(or);
                    second.setParent(or);
                    tmp.addLast(or);
                    continue;
                }
                tmp.addLast(first);
            }
            nodes = tmp;
            tmp = new LinkedList();
        }
        return (Node)nodes.getFirst();
    }
}

