/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.terminalsets;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.terminalsets.TerminalSetBuilder;
import it.units.inginf.male.tree.Constant;
import it.units.inginf.male.tree.Leaf;
import it.units.inginf.male.tree.NodeFactory;
import it.units.inginf.male.utils.BasicTokenizer;
import it.units.inginf.male.utils.Tokenizer;
import it.units.inginf.male.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class TokenizedTerminalSetBuilder
implements TerminalSetBuilder {
    private final Tokenizer tokenizer = new BasicTokenizer();

    private boolean matchW(String string) {
        return string.length() == 1 && this.matchW(string.charAt(0));
    }

    private boolean matchW(char character) {
        return Character.isAlphabetic(character) || Character.isDigit(character) || character == '_';
    }

    @Override
    public void setup(Configuration configuration) {
        this.setup(configuration, configuration.getDatasetContainer().getTrainingDataset());
    }

    private void setup(Configuration configuration, DataSet dataSet) {
        Double TOKEN_THREASHOLD = 80.0;
        boolean DISCARD_W_TOKENS = true;
        Map<String, String> parameters = configuration.getPopulationBuilderParameters();
        if (parameters != null) {
            if (parameters.containsKey("tokenThreashold")) {
                TOKEN_THREASHOLD = Double.valueOf(parameters.get("tokenThreashold"));
            }
            if (parameters.containsKey("discardWtokens")) {
                DISCARD_W_TOKENS = Boolean.valueOf(parameters.get("discardWtokens"));
            }
        }
        TreeSet<Character> charset = new TreeSet<Character>();
        NodeFactory nodeFactory = configuration.getNodeFactory();
        HashSet<Leaf> terminalSet = new HashSet<Leaf>(nodeFactory.getTerminalSet());
        HashMap<String, Double> tokensCounter = new HashMap<String, Double>();
        HashMap<String, Double> winnerTokens = new HashMap<String, Double>();
        for (DataSet.Example example : dataSet.getExamples()) {
            for (String match : example.getMatchedStrings()) {
                for (char c : match.toCharArray()) {
                    charset.add(Character.valueOf(c));
                }
                List<String> tokens = this.tokenizer.tokenize(match);
                HashSet<String> tokensSet = new HashSet<String>(tokens);
                for (String token : tokensSet) {
                    if (this.matchW(token) && DISCARD_W_TOKENS) continue;
                    if (tokensCounter.containsKey(token)) {
                        Double value;
                        Double d = value = (Double)tokensCounter.get(token);
                        Double d2 = value = Double.valueOf(value + 1.0);
                        tokensCounter.put(token, value);
                        continue;
                    }
                    tokensCounter.put(token, 1.0);
                }
            }
        }
        int numberOfMatches = dataSet.getNumberMatches();
        for (Map.Entry entry : tokensCounter.entrySet()) {
            String key = (String)entry.getKey();
            Double double1 = (Double)entry.getValue();
            Double doublePercentange = double1 * 100.0 / (double)numberOfMatches;
            entry.setValue(doublePercentange);
            if (!(doublePercentange >= TOKEN_THREASHOLD)) continue;
            winnerTokens.put(key, doublePercentange);
        }
        for (Map.Entry entry : winnerTokens.entrySet()) {
            String token = (String)entry.getKey();
            double v = (Double)entry.getValue();
            Constant leaf = new Constant(Utils.escape(token));
            terminalSet.add(leaf);
        }
        terminalSet.addAll(Utils.generateRegexRanges(charset));
        terminalSet.add(new Constant("\\d"));
        terminalSet.add(new Constant("\\w"));
        nodeFactory.getTerminalSet().clear();
        nodeFactory.getTerminalSet().addAll(terminalSet);
    }

    @Override
    public void setup(Context context) {
        context.getConfiguration().initNodeFactory();
        this.setup(context.getConfiguration(), context.getCurrentDataSet());
    }
}

