/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.utils;

public class BasicStats {
    public long fp = 0L;
    public transient long fn = 0L;
    public long tp = 0L;
    public transient long tn = 0L;

    public double accuracy() {
        return (double)(this.tp + this.tn) / (double)(this.tp + this.tn + this.fp + this.fn);
    }

    public double precision() {
        return (double)this.tp / (double)(this.tp + this.fp);
    }

    public double recall() {
        return (double)this.tp / (double)(this.tp + this.fn);
    }

    public double fpr() {
        return (double)this.fp / (double)(this.tn + this.fp);
    }

    public double fnr() {
        return (double)this.fn / (double)(this.tp + this.fn);
    }

    public double recall(int positives) {
        return (double)this.tp / (double)positives;
    }

    public double trueNegativeRate() {
        return (double)this.tn / (double)(this.tn + this.fn);
    }

    public double specificity() {
        return (double)this.tn / (double)(this.tn + this.fp);
    }

    public double specificity(int negatives) {
        return (double)this.tn / (double)negatives;
    }

    public double fMeasure() {
        double precision = this.precision();
        double recall = this.recall();
        return 2.0 * (precision * recall) / (precision + recall);
    }

    public BasicStats add(BasicStats stats) {
        this.fp += stats.fp;
        this.fn += stats.fn;
        this.tp += stats.tp;
        this.tn += stats.tn;
        return this;
    }
}

