/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.utils;

import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.objective.Ranking;
import it.units.inginf.male.tree.RegexRange;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utils {
    private static final transient Set<Character> quoteList = new TreeSet<Character>(Arrays.asList(Character.valueOf('?'), Character.valueOf('+'), Character.valueOf('*'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\\'), Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('-'), Character.valueOf('&')));

    public static float[] calculateMeanFitness(List<Ranking> population) {
        float[] out = new float[population.get(0).getFitness().length];
        for (Ranking r : population) {
            double[] fitness = r.getFitness();
            for (int i = 0; i < out.length; ++i) {
                int n = i;
                out[n] = (float)((double)out[n] + fitness[i]);
            }
        }
        int i = 0;
        while (i < out.length) {
            int n = i++;
            out[n] = out[n] / (float)population.size();
        }
        return out;
    }

    public static boolean isAParetoDominateByB(double[] fitnessA, double[] fitnessB) {
        boolean dominate = false;
        for (int i = 0; i < fitnessA.length; ++i) {
            if (fitnessA[i] > fitnessB[i]) {
                dominate = true;
                continue;
            }
            if (!(fitnessA[i] < fitnessB[i])) continue;
            return false;
        }
        return dominate;
    }

    public static List<Ranking> getFirstParetoFront(List<Ranking> tmp) {
        LinkedList<Ranking> front = new LinkedList<Ranking>();
        for (Ranking r1 : tmp) {
            boolean isDominate = false;
            for (Ranking r2 : tmp) {
                if (r1.equals(r2) || !Utils.isAParetoDominateByB(r1.getFitness(), r2.getFitness())) continue;
                isDominate = true;
                break;
            }
            if (isDominate) continue;
            front.add(r1);
        }
        return front;
    }

    public static String cpuInfo() throws IOException {
        String line;
        if (!System.getProperty("os.name").toLowerCase().contains("linux")) {
            return "Unaviable";
        }
        FileInputStream fis = new FileInputStream(new File("/proc/cpuinfo"));
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader bufferedReader = new BufferedReader(isr);
        while ((line = bufferedReader.readLine()) != null) {
            if (!line.matches("model name.*")) continue;
            bufferedReader.close();
            return line.replace("model name\t: ", "");
        }
        return "";
    }

    public static double diversity(List<Ranking> population) {
        HashSet<String> tmp = new HashSet<String>();
        for (Ranking r : population) {
            tmp.add(r.getDescription());
        }
        return (double)(100 * tmp.size()) / (double)population.size();
    }

    public static void removeEmptyExtractions(List<DataSet.Bounds> extractions) {
        Iterator<DataSet.Bounds> it = extractions.iterator();
        while (it.hasNext()) {
            DataSet.Bounds bounds = it.next();
            if (bounds.size() != 0) continue;
            it.remove();
        }
    }

    public static void saveFile(String text, String pathOfFile) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(pathOfFile), "utf-8");
            writer.write(text);
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, "Cannot save:", ex);
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static Set<String> subparts(String word) {
        return Utils.subparts(word, 1, 4);
    }

    public static Set<String> subparts(String word, int nMin, int nMax) {
        HashSet<String> subparts = new HashSet<String>();
        for (int n = nMin; n <= nMax; ++n) {
            for (int i = 0; i < word.length(); ++i) {
                StringBuilder builder = new StringBuilder();
                String w = word.substring(i, Math.min(i + n, word.length()));
                for (char c : w.toCharArray()) {
                    builder.append(Utils.escape(c));
                }
                subparts.add(builder.toString());
            }
        }
        return subparts;
    }

    public static String escape(char c) {
        if (quoteList.contains(Character.valueOf(c))) {
            return "\\" + c;
        }
        return "" + c;
    }

    public static String escape(String string) {
        char[] stringChars;
        StringBuilder stringBuilder = new StringBuilder();
        for (char character : stringChars = string.toCharArray()) {
            stringBuilder.append(Utils.escape(character));
        }
        return stringBuilder.toString();
    }

    public static List<RegexRange> generateRegexRanges(Collection<Character> charset) {
        LinkedList<RegexRange> regexRangesList = new LinkedList<RegexRange>();
        TreeSet<Character> orderedCharset = new TreeSet<Character>(charset);
        Character start = null;
        Character old = null;
        for (Character c : charset) {
            if (old == null) {
                start = old = orderedCharset.first();
                continue;
            }
            if (c.charValue() - old.charValue() > 1 || Objects.equals(orderedCharset.last(), c)) {
                if (old.charValue() - start.charValue() > 1) {
                    regexRangesList.add(new RegexRange(Utils.escape(start.charValue()) + "-" + Utils.escape(old.charValue())));
                }
                start = c;
            }
            old = c;
        }
        return regexRangesList;
    }
}

