/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.configuration.Configurator;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.outputs.Results;
import it.units.inginf.male.strategy.ExecutionStrategy;
import it.units.inginf.male.strategy.impl.CoolTextualExecutionListener;
import it.units.inginf.male.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

public class Main {
    public static void main(String[] args) throws TreeEvaluationException, IOException, Exception {
        if (args.length < 1) {
            Main.printUsage();
            System.exit(0);
        }
        Configuration configuration = Configurator.configure(args[0]);
        Logger.getLogger("").addHandler(new FileHandler(new File(configuration.getOutputFolder(), "log.xml").getCanonicalPath()));
        Results results = new Results(configuration);
        results.setMachineHardwareSpecifications(Utils.cpuInfo());
        ExecutionStrategy strategy = configuration.getStrategy();
        long startTime = System.currentTimeMillis();
        strategy.execute(configuration, new CoolTextualExecutionListener(args[0], configuration, results));
        if (configuration.getPostProcessor() != null) {
            startTime = System.currentTimeMillis() - startTime;
            configuration.getPostProcessor().elaborate(configuration, results, startTime);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar \"Random_Regex_Turtle.jar\" configFileName [startGui]");
    }
}

