/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.evaluators;

import it.units.inginf.male.evaluators.CachedEvaluator;
import it.units.inginf.male.evaluators.DefaultTreeEvaluator;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.utils.Triplet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class CachedTreeEvaluator
extends DefaultTreeEvaluator
implements CachedEvaluator {
    private final WeakHashMap<Triplet<Context.EvaluationPhases, Boolean, String>, List<List<DataSet.Bounds>>> cache = new WeakHashMap();
    private long hit = 0L;
    private long miss = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<DataSet.Bounds>> evaluate(Node root, Context context) throws TreeEvaluationException {
        List<List<DataSet.Bounds>> results;
        StringBuilder sb = new StringBuilder();
        root.describe(sb);
        Triplet<Context.EvaluationPhases, Boolean, String> key = new Triplet<Context.EvaluationPhases, Boolean, String>(context.getPhase(), context.isStripedPhase(), sb.toString());
        WeakHashMap<Triplet<Context.EvaluationPhases, Boolean, String>, List<List<DataSet.Bounds>>> weakHashMap = this.cache;
        synchronized (weakHashMap) {
            results = this.cache.get(key);
        }
        if (results != null) {
            ++this.hit;
            return results;
        }
        ++this.miss;
        results = super.evaluate(root, context);
        weakHashMap = this.cache;
        synchronized (weakHashMap) {
            this.cache.put(key, results);
        }
        return results;
    }

    @Override
    public double getRatio() {
        return (double)this.hit / (double)(this.hit + this.miss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCacheSizeBytes() {
        WeakHashMap<Triplet<Context.EvaluationPhases, Boolean, String>, List<List<DataSet.Bounds>>> weakHashMap = this.cache;
        synchronized (weakHashMap) {
            long cacheSize = 0L;
            for (Map.Entry<Triplet<Context.EvaluationPhases, Boolean, String>, List<List<DataSet.Bounds>>> entry : this.cache.entrySet()) {
                List<List<DataSet.Bounds>> list = entry.getValue();
                for (List<DataSet.Bounds> exampleResult : list) {
                    cacheSize += (long)exampleResult.size();
                }
            }
            return cacheSize *= 8L;
        }
    }
}

