/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.evaluators;

import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.evaluators.TreeEvaluator;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.tree.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DefaultTreeEvaluator
implements TreeEvaluator {
    @Override
    public List<List<DataSet.Bounds>> evaluate(Node root, Context context) throws TreeEvaluationException {
        ArrayList<List<DataSet.Bounds>> results = new ArrayList<List<DataSet.Bounds>>(context.getCurrentDataSetLength());
        StringBuilder sb = new StringBuilder();
        root.describe(sb);
        try {
            Pattern regex = Pattern.compile(sb.toString());
            Matcher matcher = regex.matcher("");
            int i = 0;
            DataSet dataSet = context.getCurrentDataSet();
            for (DataSet.Example example : dataSet.getExamples()) {
                try {
                    Matcher m = matcher.reset(example.getString());
                    LinkedList<DataSet.Bounds> b = new LinkedList<DataSet.Bounds>();
                    while (m.find()) {
                        DataSet.Bounds bounds = new DataSet.Bounds(matcher.start(0), matcher.end(0));
                        b.add(bounds);
                    }
                    results.add(b);
                }
                catch (StringIndexOutOfBoundsException ex) {
                    results.add(Collections.emptyList());
                }
                ++i;
            }
        }
        catch (PatternSyntaxException ex) {
            throw new TreeEvaluationException(ex);
        }
        return results;
    }

    @Override
    public void setup(Map<String, String> parameters) {
    }
}

