/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.inputs;

import it.units.inginf.male.utils.Range;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSet {
    public String name;
    public String description;
    public String regexTarget;
    public List<Example> examples = new LinkedList<Example>();
    private transient int numberMatches;
    private transient int numberUnmatches;
    private transient int numberMatchedChars;
    private transient int numberUnmatchedChars;
    private transient int numberUnAnnotatedChars;
    private transient int numberOfChars;
    private transient DataSet stripedDataset;
    private transient Map<Long, List<DataSet>> separateAndConquerLevels = new ConcurrentHashMap<Long, List<DataSet>>();
    private static final Logger LOG = Logger.getLogger(DataSet.class.getName());

    public DataSet() {
    }

    public DataSet(String name) {
        this.name = name;
    }

    public DataSet(String name, String description, String regexTarget) {
        this.name = name;
        this.description = description;
        this.regexTarget = regexTarget;
    }

    public void updateStats() {
        this.numberMatches = 0;
        this.numberUnmatches = 0;
        this.numberMatchedChars = 0;
        this.numberUnmatchedChars = 0;
        this.numberUnAnnotatedChars = 0;
        this.numberOfChars = 0;
        for (Example ex : this.examples) {
            this.numberMatches += ex.match.size();
            this.numberUnmatches += ex.unmatch.size();
            this.numberMatchedChars += ex.getNumberMatchedChars();
            this.numberUnmatchedChars += ex.getNumberUnmatchedChars();
            this.numberOfChars += ex.getNumberOfChars();
        }
        this.numberUnAnnotatedChars = this.numberOfChars - this.numberMatchedChars - this.numberUnmatchedChars;
    }

    public int getNumberMatches() {
        return this.numberMatches;
    }

    public int getNumberUnmatches() {
        return this.numberUnmatches;
    }

    public int getNumberMatchedChars() {
        return this.numberMatchedChars;
    }

    public int getNumberUnmatchedChars() {
        return this.numberUnmatchedChars;
    }

    public int getNumberUnannotatedChars() {
        return this.numberUnAnnotatedChars;
    }

    public int getNumberOfChars() {
        return this.numberOfChars;
    }

    public int getNumberExamples() {
        return this.examples.size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRegexTarget() {
        return this.regexTarget;
    }

    public void setRegexTarget(String regexTarget) {
        this.regexTarget = regexTarget;
    }

    public String getStatsString() {
        StringBuilder stats = new StringBuilder();
        stats.append("DataSet ").append(this.name).append(" stats:\n").append("number examples: ").append(this.getNumberExamples()).append("\noverall chars in dataset: ").append(this.getNumberOfChars()).append("\nnumber matches: ").append(this.getNumberMatches()).append("\ncharacters in matches: ").append(this.getNumberMatchedChars()).append("\nnumber unmatches: ").append(this.getNumberUnmatches()).append("\ncharacters in unmatches: ").append(this.getNumberUnmatchedChars()).append("\nunannotated chars: ").append(this.getNumberUnannotatedChars());
        return stats.toString();
    }

    public void randomize() {
        Random random = new Random();
        for (int i = 0; i < this.examples.size(); ++i) {
            if (i * 100 / this.examples.size() % 5 == 0) {
                System.out.format("randomize %d%%\n", i * 100 / this.examples.size());
            }
            int destIndex = random.nextInt(this.examples.size());
            Example ex1 = this.examples.get(i);
            Example ex2 = this.examples.get(destIndex);
            this.examples.set(i, ex2);
            this.examples.set(destIndex, ex1);
        }
    }

    public void populateUnmatchesFromMatches() {
        for (Example ex : this.examples) {
            ex.populateUnmatchesFromMatches();
        }
    }

    public void populateAnnotatedStrings() {
        for (Example example : this.examples) {
            example.populateAnnotatedStrings();
        }
    }

    public List<Example> getExamples() {
        return this.examples;
    }

    public DataSet subDataset(String name, List<Range> ranges) {
        DataSet subDataset = new DataSet(name);
        for (Range range : ranges) {
            for (int index = range.getStartIndex(); index <= range.getEndIndex(); ++index) {
                subDataset.getExamples().add(this.getExamples().get(index));
            }
        }
        return subDataset;
    }

    public DataSet initStripedDatasetView(double marginSize) {
        this.stripedDataset = new DataSet(this.name, this.description, this.regexTarget);
        for (Example example : this.examples) {
            this.stripedDataset.getExamples().addAll(DataSet.stripeExample(example, marginSize));
        }
        return this.stripedDataset;
    }

    protected static List<Example> stripeExample(Example example, double marginSize) {
        LinkedList<Example> slicesExampleList = new LinkedList<Example>();
        List<Bounds> savedBounds = new LinkedList<Bounds>();
        for (Bounds match : example.getMatch()) {
            int charMargin = (int)Math.max((double)match.size() * marginSize / 2.0, 1.0);
            Bounds grownMatch = new Bounds(match.start - charMargin, match.end + charMargin);
            grownMatch.start = grownMatch.start >= 0 ? grownMatch.start : 0;
            grownMatch.end = grownMatch.end <= example.getNumberOfChars() ? grownMatch.end : example.getNumberOfChars();
            savedBounds.add(grownMatch);
        }
        savedBounds = Bounds.mergeBounds(savedBounds);
        for (Bounds slice : savedBounds) {
            Example sliceExample = new Example();
            sliceExample.setString(example.getString().substring(slice.start, slice.end));
            for (Bounds match : example.getMatch()) {
                if (match.start >= slice.end) break;
                Bounds slicedMatch = match.windowView(slice);
                if (slicedMatch == null) continue;
                sliceExample.getMatch().add(slicedMatch);
            }
            for (Bounds unmatch : example.getUnmatch()) {
                if (unmatch.start >= slice.end) break;
                Bounds slicedUnmatch = unmatch.windowView(slice);
                if (slicedUnmatch == null) continue;
                sliceExample.getUnmatch().add(slicedUnmatch);
            }
            sliceExample.populateAnnotatedStrings();
            slicesExampleList.add(sliceExample);
        }
        return slicesExampleList;
    }

    public DataSet getStripedDataset() {
        return this.stripedDataset;
    }

    public DataSet getSeparateAndConquerDataSet(int divideEtImperaLevel, int jobId) {
        if (divideEtImperaLevel == 0) {
            return this;
        }
        return this.getSeparateAndConquerLevels(jobId).get(divideEtImperaLevel - 1);
    }

    public boolean addSeparateAndConquerLevel(String individualRegex, int jobId) {
        return this.addSeparateAndConquerLevel(individualRegex, jobId, true, false);
    }

    public boolean addSeparateAndConquerLevel(String individualRegex, int jobId, boolean convertToUnmatch, boolean isFlagging) {
        boolean modified = false;
        DataSet oldDataset = this.getLastSeparateAndConquerDataSet(jobId);
        DataSet dataset = oldDataset.reduceSeparateAndConquerDataset(individualRegex, convertToUnmatch, isFlagging);
        dataset.updateStats();
        modified = dataset.getNumberMatches() != oldDataset.getNumberMatches();
        this.getSeparateAndConquerLevels(jobId).add(dataset);
        if (this.getStripedDataset() != null) {
            modified = this.getStripedDataset().addSeparateAndConquerLevel(individualRegex, jobId, convertToUnmatch, isFlagging) || modified;
        }
        return modified;
    }

    private DataSet reduceSeparateAndConquerDataset(String individualRegex, boolean convertToUnmatch, boolean isFlagging) {
        Pattern pattern = Pattern.compile(individualRegex);
        Matcher individualRegexMatcher = pattern.matcher("");
        DataSet reducedDataset = new DataSet(this.name, "Reduction: " + individualRegex, this.regexTarget);
        for (Example example : this.examples) {
            if (!isFlagging) {
                reducedDataset.getExamples().add(this.reduceSeparateAndConquerExample(example, individualRegexMatcher, convertToUnmatch));
                continue;
            }
            reducedDataset.getExamples().add(this.reduceSeparateAndConquerFlaggingExample(example, individualRegexMatcher));
        }
        return reducedDataset;
    }

    private boolean isTruePositiveFlaggingExample(Example example, Matcher individualRegexMatcher) {
        try {
            Matcher m = individualRegexMatcher.reset(example.getString());
            return m.find() && !example.match.isEmpty();
        }
        catch (StringIndexOutOfBoundsException ex) {
            return false;
        }
    }

    private Example reduceSeparateAndConquerFlaggingExample(Example example, Matcher individualRegexMatcher) {
        if (!this.isTruePositiveFlaggingExample(example, individualRegexMatcher)) {
            return new Example(example);
        }
        Example unannotatedExample = new Example();
        unannotatedExample.setString(example.getString());
        return unannotatedExample;
    }

    private Example reduceSeparateAndConquerExample(Example example, Matcher individualRegexMatcher, boolean convertToUnmatch) {
        return this.manipulateSeparateAndConquerExample(example, individualRegexMatcher, convertToUnmatch);
    }

    private Example manipulateSeparateAndConquerExample(Example example, Matcher individualRegexMatcher, boolean convertToUnmatch) {
        Example exampleClone = new Example(example);
        LinkedList<Bounds> extractions = new LinkedList<Bounds>();
        try {
            Matcher m = individualRegexMatcher.reset(example.getString());
            while (m.find()) {
                Bounds bounds = new Bounds(m.start(0), m.end(0));
                extractions.add(bounds);
            }
        }
        catch (StringIndexOutOfBoundsException m) {
            // empty catch block
        }
        Iterator<Bounds> it = exampleClone.getMatch().iterator();
        block3: while (it.hasNext()) {
            Bounds match = it.next();
            for (Bounds extraction : extractions) {
                if (match.equals(extraction)) {
                    it.remove();
                    if (!convertToUnmatch) continue block3;
                    exampleClone.getUnmatch().add(match);
                    continue block3;
                }
                if (extraction.start <= match.end) continue;
                continue block3;
            }
        }
        exampleClone.mergeUnmatchesBounds();
        exampleClone.populateAnnotatedStrings();
        return exampleClone;
    }

    public DataSet getLastSeparateAndConquerDataSet(int jobId) {
        List<DataSet> datasetsList = this.getSeparateAndConquerLevels(jobId);
        if (datasetsList.isEmpty()) {
            return this;
        }
        return datasetsList.get(datasetsList.size() - 1);
    }

    public int getNumberOfSeparateAndConquerLevels(int jobId) {
        return this.getSeparateAndConquerLevels(jobId).size();
    }

    public Map<Long, List<DataSet>> getAllSeparateAndConquerLevels() {
        return this.separateAndConquerLevels;
    }

    public List<DataSet> getSeparateAndConquerLevels(long jobId) {
        if (this.separateAndConquerLevels.containsKey(jobId)) {
            return this.separateAndConquerLevels.get(jobId);
        }
        LinkedList<DataSet> newDatasetList = new LinkedList<DataSet>();
        this.separateAndConquerLevels.put(jobId, newDatasetList);
        return newDatasetList;
    }

    public void resetSeparateAndConquer(long jobId) {
        this.getSeparateAndConquerLevels(jobId).clear();
        if (this.getStripedDataset() != null) {
            this.getStripedDataset().getSeparateAndConquerLevels(jobId).clear();
        }
    }

    public void resetAllSeparateAndConquer() {
        this.getAllSeparateAndConquerLevels().clear();
    }

    public void removeSeparateAndConquerLevel(int jobID) {
        List<DataSet> separateAndConquerLevelsForJob = this.getSeparateAndConquerLevels(jobID);
        if (!separateAndConquerLevelsForJob.isEmpty()) {
            separateAndConquerLevelsForJob.remove(separateAndConquerLevelsForJob.size() - 1);
        }
    }

    public Example getExample(int index) {
        return this.examples.get(index);
    }

    public static class Bounds
    implements Comparable<Bounds> {
        public int start;
        public int end;

        public Bounds(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int size() {
            return this.end - this.start;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + this.start;
            hash = 97 * hash + this.end;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Bounds other = (Bounds)obj;
            return this.end == other.end && this.start == other.start;
        }

        public static List<Bounds> mergeBounds(List<Bounds> boundsList) {
            LinkedList<Bounds> newBoundsList = new LinkedList<Bounds>();
            if (boundsList.isEmpty()) {
                return newBoundsList;
            }
            Collections.sort(boundsList);
            Bounds prevBounds = new Bounds(boundsList.get((int)0).start, boundsList.get((int)0).end);
            for (int i = 1; i < boundsList.size(); ++i) {
                Bounds currentBounds = boundsList.get(i);
                if (currentBounds.start <= prevBounds.end) {
                    prevBounds.end = Math.max(currentBounds.end, prevBounds.end);
                    continue;
                }
                newBoundsList.add(prevBounds);
                prevBounds = new Bounds(currentBounds.start, currentBounds.end);
            }
            newBoundsList.add(prevBounds);
            return newBoundsList;
        }

        public Bounds windowView(Bounds rangeBounds) {
            Bounds newBounds = new Bounds(this.start - rangeBounds.start, this.end - rangeBounds.start);
            if (newBounds.start >= rangeBounds.size() || newBounds.end <= 0) {
                return null;
            }
            newBounds.start = Math.max(newBounds.start, 0);
            newBounds.end = Math.min(newBounds.end, rangeBounds.size());
            return newBounds;
        }

        @Override
        public int compareTo(Bounds o) {
            return this.start - o.start;
        }

        public boolean isSubsetOf(Bounds bounds) {
            return this.start >= bounds.start && this.end <= bounds.end;
        }

        public boolean overlaps(Bounds bounds) {
            return this.start == bounds.start || this.end == bounds.end || this.start < bounds.end && this.end > bounds.start;
        }

        public static int countRangesThatCollideZone(List<Bounds> ranges, List<Bounds> zoneRanges) {
            int overallEOAA = 0;
            Collections.sort(zoneRanges);
            block0: for (Bounds extractedBounds : ranges) {
                for (Bounds expectedBounds : zoneRanges) {
                    if (expectedBounds.start >= extractedBounds.end) continue block0;
                    if (!extractedBounds.overlaps(expectedBounds)) continue;
                    ++overallEOAA;
                    continue block0;
                }
            }
            return overallEOAA;
        }
    }

    public static class Example {
        public String string;
        public List<Bounds> match = new LinkedList<Bounds>();
        public List<Bounds> unmatch = new LinkedList<Bounds>();
        protected transient List<String> matchedStrings = new LinkedList<String>();
        protected transient List<String> unmatchedStrings = new LinkedList<String>();

        public Example() {
        }

        public Example(Example example) {
            this.string = example.string;
            this.match = new LinkedList<Bounds>(example.match);
            this.unmatch = new LinkedList<Bounds>(example.unmatch);
            if (example.matchedStrings != null) {
                this.matchedStrings = new LinkedList<String>(example.matchedStrings);
            }
            if (example.unmatchedStrings != null) {
                this.unmatchedStrings = new LinkedList<String>(example.unmatchedStrings);
            }
        }

        public void addMatchBounds(int bs, int bf) {
            Bounds boundaries = new Bounds(bs, bf);
            this.match.add(boundaries);
        }

        public void addUnmatchBounds(int bs, int bf) {
            Bounds boundaries = new Bounds(bs, bf);
            this.unmatch.add(boundaries);
        }

        public int getNumberMatchedChars() {
            return this.getNumberCharsInsideIntervals(this.match);
        }

        public int getNumberUnmatchedChars() {
            return this.getNumberCharsInsideIntervals(this.unmatch);
        }

        public int getNumberOfChars() {
            return this.string.length();
        }

        private int getNumberCharsInsideIntervals(List<Bounds> textIntervals) {
            int countChars = 0;
            for (Bounds interval : textIntervals) {
                countChars += interval.end - interval.start;
            }
            return countChars;
        }

        public void populateAnnotatedStrings() {
            this.matchedStrings.clear();
            for (Bounds bounds : this.match) {
                this.matchedStrings.add(this.string.substring(bounds.start, bounds.end));
            }
            this.unmatchedStrings.clear();
            for (Bounds bounds : this.unmatch) {
                this.unmatchedStrings.add(this.string.substring(bounds.start, bounds.end));
            }
        }

        public List<String> getMatchedStrings() {
            return this.matchedStrings;
        }

        public List<String> getUnmatchedStrings() {
            return this.unmatchedStrings;
        }

        public String getString() {
            return this.string;
        }

        public List<Bounds> getMatch() {
            return this.match;
        }

        public List<Bounds> getUnmatch() {
            return this.unmatch;
        }

        public void setString(String string) {
            this.string = string;
        }

        public void populateUnmatchesFromMatches() {
            this.unmatch.clear();
            int previousMatchFinalIndex = 0;
            for (Bounds oneMatch : this.match) {
                if (oneMatch.start > previousMatchFinalIndex) {
                    this.addUnmatchBounds(previousMatchFinalIndex, oneMatch.start);
                }
                previousMatchFinalIndex = oneMatch.end;
            }
            if (previousMatchFinalIndex < this.string.length()) {
                this.addUnmatchBounds(previousMatchFinalIndex, this.string.length());
            }
        }

        public int getNumberMatches() {
            return this.match.size();
        }

        public List<String> getAnnotatedStrings() {
            LinkedList<String> annotatedStrings = new LinkedList<String>();
            for (Bounds bounds : this.getMatch()) {
                annotatedStrings.add(this.getString().substring(bounds.start, bounds.end));
            }
            for (Bounds bounds : this.getUnmatch()) {
                annotatedStrings.add(this.getString().substring(bounds.start, bounds.end));
            }
            return annotatedStrings;
        }

        public List<String> getOrderedAnnotatedStrings() {
            LinkedList<Bounds> boundsList = new LinkedList<Bounds>(this.getMatch());
            boundsList.addAll(this.getUnmatch());
            Collections.sort(boundsList);
            LinkedList<String> annotatedStrings = new LinkedList<String>();
            for (Bounds bounds : boundsList) {
                annotatedStrings.add(this.getString().substring(bounds.start, bounds.end));
            }
            return annotatedStrings;
        }

        public void mergeUnmatchesBounds() {
            this.unmatch = Bounds.mergeBounds(this.unmatch);
        }
    }
}

