/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.objective;

import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.evaluators.TreeEvaluator;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.objective.Objective;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.utils.BasicStats;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharmaskMatchLengthObjective
implements Objective {
    private Context context;

    @Override
    public void setup(Context context) {
        this.context = context;
    }

    @Override
    public double[] fitness(Node individual) {
        double fitnessLenght;
        List<List<DataSet.Bounds>> evaluate;
        DataSet dataSetView = this.context.getCurrentDataSet();
        TreeEvaluator evaluator = this.context.getConfiguration().getEvaluator();
        double[] fitness = new double[3];
        try {
            evaluate = evaluator.evaluate(individual, this.context);
            StringBuilder builder = new StringBuilder();
            individual.describe(builder);
            fitnessLenght = builder.length();
        }
        catch (TreeEvaluationException ex) {
            Logger.getLogger(CharmaskMatchLengthObjective.class.getName()).log(Level.SEVERE, null, ex);
            Arrays.fill(fitness, Double.POSITIVE_INFINITY);
            return fitness;
        }
        BasicStats statsOverall = new BasicStats();
        BasicStats statsCharsOverall = new BasicStats();
        int i = 0;
        for (List<DataSet.Bounds> result : evaluate) {
            BasicStats stats = new BasicStats();
            BasicStats statsChars = new BasicStats();
            DataSet.Example example = dataSetView.getExample(i);
            List<DataSet.Bounds> expectedMatchMask = example.getMatch();
            List<DataSet.Bounds> expectedUnmatchMask = example.getUnmatch();
            stats.tp = this.countIdenticalRanges(result, expectedMatchMask);
            stats.fp = (long)result.size() - stats.tp;
            statsChars.tp = this.intersection(result, expectedMatchMask);
            statsChars.fp = this.intersection(result, expectedUnmatchMask);
            statsOverall.add(stats);
            statsCharsOverall.add(statsChars);
            ++i;
        }
        statsCharsOverall.tn = (long)dataSetView.getNumberUnmatchedChars() - statsCharsOverall.fp;
        statsCharsOverall.fn = (long)dataSetView.getNumberMatchedChars() - statsCharsOverall.tp;
        fitness[0] = (statsCharsOverall.fpr() + statsCharsOverall.fnr()) * 100.0;
        fitness[1] = Math.abs(statsOverall.fp + statsOverall.tp - (long)dataSetView.getNumberMatches());
        fitness[2] = fitnessLenght;
        return fitness;
    }

    private int intersection(List<DataSet.Bounds> extractedRanges, List<DataSet.Bounds> expectedRanges) {
        int overallNumChars = 0;
        for (DataSet.Bounds extractedBounds : extractedRanges) {
            for (DataSet.Bounds expectedBounds : expectedRanges) {
                int numChars = Math.min(extractedBounds.end, expectedBounds.end) - Math.max(extractedBounds.start, expectedBounds.start);
                overallNumChars += Math.max(0, numChars);
            }
        }
        return overallNumChars;
    }

    private int countIdenticalRanges(List<DataSet.Bounds> rangesA, List<DataSet.Bounds> rangesB) {
        int identicalRanges = 0;
        block0: for (DataSet.Bounds boundsA : rangesA) {
            for (DataSet.Bounds boundsB : rangesB) {
                if (!boundsA.equals(boundsB)) continue;
                ++identicalRanges;
                continue block0;
            }
        }
        return identicalRanges;
    }

    @Override
    public TreeEvaluator getTreeEvaluator() {
        return this.context.getConfiguration().getEvaluator();
    }

    @Override
    public Objective cloneObjective() {
        return new CharmaskMatchLengthObjective();
    }
}

