/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.outputs.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class DoubleTypeAdapter
extends TypeAdapter<Double> {
    @Override
    public void write(JsonWriter out, Double value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (Double.isNaN(value)) {
            out.value("NaN");
            return;
        }
        out.value(value);
    }

    @Override
    public Double read(JsonReader in) throws IOException {
        Double nextDouble;
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            nextDouble = in.nextDouble();
        }
        catch (NumberFormatException ex) {
            nextDouble = Double.NaN;
        }
        return nextDouble;
    }
}

