/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.strategy.impl;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.strategy.ExecutionListener;
import it.units.inginf.male.strategy.ExecutionListenerFactory;
import it.units.inginf.male.strategy.RunStrategy;
import it.units.inginf.male.strategy.impl.AbstractExecutionStrategy;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultithreadStrategy
extends AbstractExecutionStrategy {
    public static final String THREADS_KEY = "threads";
    private static final Logger LOG = Logger.getLogger(MultithreadStrategy.class.getName());
    ExecutorService executor;
    private volatile Thread workingThread = null;
    private volatile boolean terminated = false;

    private int countThreads(Map<String, String> parameters) {
        int threads;
        String paramValue = parameters.get(THREADS_KEY);
        try {
            threads = Integer.parseInt(paramValue);
        }
        catch (NumberFormatException x) {
            threads = Runtime.getRuntime().availableProcessors();
            LOG.log(Level.WARNING, "Falling back to default threads count: {0}", threads);
        }
        return threads;
    }

    @Override
    public void execute(Configuration configuration, ExecutionListenerFactory listenerFactory) throws Exception {
        this.workingThread = Thread.currentThread();
        listenerFactory.register(this);
        Map<String, String> parameters = configuration.getStrategyParameters();
        int threads = this.countThreads(parameters);
        Class<? extends RunStrategy> strategyClass = this.getStrategy(parameters);
        this.executor = Executors.newFixedThreadPool(threads);
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(this.executor);
        long initialSeed = configuration.getInitialSeed();
        int jobs = configuration.getJobs();
        for (int i = 0; i < jobs; ++i) {
            RunStrategy job = strategyClass.newInstance();
            Configuration jobConf = new Configuration(configuration);
            jobConf.setJobId(i);
            jobConf.setInitialSeed(initialSeed + (long)i);
            job.setup(jobConf, listenerFactory.getNewListener());
            completionService.submit(job);
        }
        this.executor.shutdown();
        ExecutionListener listener = listenerFactory.getNewListener();
        for (int i = 0; i < jobs; ++i) {
            Future result = null;
            try {
                if (this.terminated) {
                    if (listener != null) {
                        listener.evolutionStopped();
                    }
                    return;
                }
                result = completionService.take();
            }
            catch (InterruptedException ex) {
                if (listener != null) {
                    listener.evolutionStopped();
                }
                return;
            }
            try {
                result.get();
                continue;
            }
            catch (ExecutionException x) {
                if (!(x.getCause() instanceof TreeEvaluationException)) continue;
                TreeEvaluationException ex = (TreeEvaluationException)x.getCause();
                RunStrategy strategy = ex.getAssociatedStrategy();
                LOG.log(Level.SEVERE, "Job " + strategy.getConfiguration().getJobId() + " failed with exception", ex.getCause());
                if (listener == null) continue;
                listener.evolutionFailed(strategy, ex);
            }
        }
    }

    @Override
    public void shutdown() {
        this.executor.shutdownNow();
        if (this.workingThread != null) {
            this.terminated = true;
            this.workingThread.interrupt();
        }
    }
}

