/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.configuration;

import it.units.inginf.male.configuration.ConfigurationException;
import it.units.inginf.male.configuration.DatasetContainer;
import it.units.inginf.male.configuration.EvolutionParameters;
import it.units.inginf.male.evaluators.CachedTreeEvaluator;
import it.units.inginf.male.evaluators.TreeEvaluator;
import it.units.inginf.male.generations.InitialPopulationBuilder;
import it.units.inginf.male.generations.TokenizedContextPopulationBuilder;
import it.units.inginf.male.objective.Objective;
import it.units.inginf.male.objective.PrecisionCharmaskLengthObjective;
import it.units.inginf.male.postprocessing.BasicPostprocessor;
import it.units.inginf.male.postprocessing.Postprocessor;
import it.units.inginf.male.selections.best.BasicLearningBestSelector;
import it.units.inginf.male.selections.best.BestSelector;
import it.units.inginf.male.strategy.ExecutionStrategy;
import it.units.inginf.male.strategy.impl.CombinedMultithreadStrategy;
import it.units.inginf.male.terminalsets.TerminalSetBuilder;
import it.units.inginf.male.terminalsets.TokenizedContextTerminalSetBuilder;
import it.units.inginf.male.tree.Constant;
import it.units.inginf.male.tree.Leaf;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.tree.NodeFactory;
import it.units.inginf.male.tree.RegexRange;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Configuration {
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());
    private EvolutionParameters evolutionParameters;
    private long initialSeed;
    private int jobs;
    private int jobId;
    private transient File outputFolder;
    private String outputFolderName;
    private transient Objective objective;
    private transient TreeEvaluator evaluator;
    private transient ExecutionStrategy strategy;
    private Map<String, String> strategyParameters;
    private String configName;
    private transient NodeFactory nodeFactory;
    private transient InitialPopulationBuilder populationBuilder;
    private Map<String, String> populationBuilderParameters;
    private Map<String, String> terminalSetBuilderParameters;
    private transient TerminalSetBuilder terminalSetBuilder;
    private DatasetContainer datasetContainer;
    private transient Postprocessor postprocessor;
    private Map<String, String> postprocessorParameters;
    private List<String> constants;
    private List<String> ranges;
    private List<String> operators;
    private transient BestSelector bestSelector;
    private Map<String, String> bestSelectorParameters;

    public Configuration() {
        this.evolutionParameters = new EvolutionParameters();
        this.evolutionParameters.setGenerations(1000);
        this.evolutionParameters.setPopulationSize(500);
        this.initialSeed = 0L;
        this.jobId = 0;
        this.jobs = 4;
        this.objective = new PrecisionCharmaskLengthObjective();
        this.constants = Arrays.asList("\\d", "\\w", "\\.", ":", ",", ";", "_", "=", "\"", "'", "\\\\", "/", "\\?", "\\!", "\\}", "\\{", "\\(", "\\)", "\\[", "\\]", "<", ">", "@", "#", " ", " ");
        this.ranges = new LinkedList<String>();
        this.operators = Arrays.asList("it.units.inginf.male.tree.operator.Group", "it.units.inginf.male.tree.operator.NonCapturingGroup", "it.units.inginf.male.tree.operator.ListMatch", "it.units.inginf.male.tree.operator.ListNotMatch", "it.units.inginf.male.tree.operator.MatchOneOrMore", "it.units.inginf.male.tree.operator.MatchZeroOrMore", "it.units.inginf.male.tree.operator.MatchZeroOrOne", "it.units.inginf.male.tree.operator.MatchMinMax");
        this.initNodeFactory();
        this.evaluator = new CachedTreeEvaluator();
        this.evaluator.setup(Collections.EMPTY_MAP);
        this.outputFolderName = ".";
        this.strategyParameters = new HashMap<String, String>();
        this.strategyParameters.put("runStrategy", "it.units.inginf.male.strategy.impl.SeparateAndConquerStrategy");
        this.strategyParameters.put("runStrategy2", "it.units.inginf.male.strategy.impl.DiversityElitarismStrategy");
        this.strategyParameters.put("objective2", "it.units.inginf.male.objective.CharmaskMatchLengthObjective");
        this.strategyParameters.put("threads", "2");
        this.strategy = new CombinedMultithreadStrategy();
        this.terminalSetBuilderParameters = new HashMap<String, String>();
        this.terminalSetBuilderParameters.put("tokenThreashold", "80.0");
        this.terminalSetBuilder = new TokenizedContextTerminalSetBuilder();
        this.populationBuilderParameters = new HashMap<String, String>();
        this.populationBuilderParameters.put("tokenThreashold", "80.0");
        this.populationBuilder = new TokenizedContextPopulationBuilder();
        this.postprocessorParameters = new HashMap<String, String>();
        this.postprocessor = new BasicPostprocessor();
        this.postprocessor.setup(Collections.EMPTY_MAP);
        this.bestSelectorParameters = new HashMap<String, String>();
        this.bestSelector = new BasicLearningBestSelector();
        this.bestSelector.setup(Collections.EMPTY_MAP);
    }

    public void setup() {
        this.datasetContainer.update();
        this.terminalSetBuilder.setup(this);
        this.populationBuilder.setup(this);
    }

    public Configuration(Configuration cc) {
        this.evolutionParameters = cc.getEvolutionParameters();
        this.initialSeed = cc.getInitialSeed();
        this.jobId = cc.getJobId();
        this.jobs = cc.getJobs();
        this.objective = cc.getObjective();
        this.evaluator = cc.getEvaluator();
        this.outputFolder = cc.getOutputFolder();
        this.outputFolderName = cc.getOutputFolderName();
        this.strategy = cc.getStrategy();
        this.strategyParameters = new LinkedHashMap<String, String>(cc.getStrategyParameters());
        this.configName = cc.getConfigName();
        this.populationBuilder = cc.getPopulationBuilder();
        this.terminalSetBuilderParameters = cc.getTerminalSetBuilderParameters();
        this.terminalSetBuilder = cc.getTerminalSetBuilder();
        this.populationBuilderParameters = cc.getPopulationBuilderParameters();
        this.datasetContainer = cc.getDatasetContainer();
        this.postprocessor = cc.getPostProcessor();
        this.postprocessorParameters = cc.getPostprocessorParameters();
        this.bestSelector = cc.getBestSelector();
        this.bestSelectorParameters = cc.getBestSelectorParameters();
        this.constants = cc.constants;
        this.ranges = cc.ranges;
        this.operators = cc.operators;
        this.initNodeFactory();
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public EvolutionParameters getEvolutionParameters() {
        return this.evolutionParameters;
    }

    public void setEvolutionParameters(EvolutionParameters evolutionParameters) {
        this.evolutionParameters = evolutionParameters;
    }

    public long getInitialSeed() {
        return this.initialSeed;
    }

    public void setInitialSeed(long initialSeed) {
        this.initialSeed = initialSeed;
    }

    public Map<String, String> getPostprocessorParameters() {
        return this.postprocessorParameters;
    }

    public void setPostprocessorParameters(Map<String, String> postprocessorParameters) {
        this.postprocessorParameters = postprocessorParameters;
    }

    public Map<String, String> getTerminalSetBuilderParameters() {
        return this.terminalSetBuilderParameters;
    }

    public void setTerminalSetBuilderParameters(Map<String, String> terminalSetBuilderParameters) {
        this.terminalSetBuilderParameters = terminalSetBuilderParameters;
    }

    public TerminalSetBuilder getTerminalSetBuilder() {
        return this.terminalSetBuilder;
    }

    public void setTerminalSetBuilder(TerminalSetBuilder terminalSetBuilder) {
        this.terminalSetBuilder = terminalSetBuilder;
    }

    public List<String> getConstants() {
        return this.constants;
    }

    public void setConstants(List<String> constants) {
        this.constants = constants;
    }

    public List<String> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<String> ranges) {
        this.ranges = ranges;
    }

    public List<String> getOperators() {
        return this.operators;
    }

    public void setOperators(List<String> operators) {
        this.operators = operators;
    }

    public int getJobId() {
        return this.jobId;
    }

    public void setJobId(int jobId) {
        this.jobId = jobId;
    }

    public Objective getObjective() {
        return this.objective.cloneObjective();
    }

    public void setObjective(Objective objective) {
        this.objective = objective;
    }

    public TreeEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(TreeEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public int getJobs() {
        return this.jobs;
    }

    public void setJobs(int jobs) {
        this.jobs = jobs;
    }

    public ExecutionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ExecutionStrategy strategy) {
        this.strategy = strategy;
    }

    public Map<String, String> getStrategyParameters() {
        return this.strategyParameters;
    }

    public void setStrategyParameters(Map<String, String> strategyParameters) {
        this.strategyParameters = strategyParameters;
    }

    public InitialPopulationBuilder getPopulationBuilder() {
        return this.populationBuilder;
    }

    public void setPopulationBuilder(InitialPopulationBuilder populationBuilder) {
        this.populationBuilder = populationBuilder;
    }

    public Postprocessor getPostProcessor() {
        return this.postprocessor;
    }

    public void setPostProcessor(Postprocessor postprocessor) {
        this.postprocessor = postprocessor;
    }

    public BestSelector getBestSelector() {
        return this.bestSelector;
    }

    public void setBestSelector(BestSelector bestSelector) {
        this.bestSelector = bestSelector;
    }

    public Map<String, String> getBestSelectorParameters() {
        return this.bestSelectorParameters;
    }

    public void setBestSelectorParameters(Map<String, String> bestSelectorParameters) {
        this.bestSelectorParameters = bestSelectorParameters;
    }

    public String getOutputFolderName() {
        return this.outputFolderName;
    }

    public void setOutputFolderName(String outputFolderName) {
        this.outputFolderName = outputFolderName;
        this.outputFolder = new File(this.outputFolderName);
        this.checkOutputFolder(this.outputFolder);
    }

    private void checkOutputFolder(File outputFolder) throws ConfigurationException {
        if (outputFolder == null) {
            throw new IllegalArgumentException("The output folder must be set");
        }
        if (!outputFolder.isDirectory() && !outputFolder.mkdirs()) {
            throw new ConfigurationException("Unable to create output folder \"" + outputFolder + "\"");
        }
    }

    public DatasetContainer getDatasetContainer() {
        return this.datasetContainer;
    }

    public void setDatasetContainer(DatasetContainer datasetContainer) {
        this.datasetContainer = datasetContainer;
    }

    public Map<String, String> getPopulationBuilderParameters() {
        return this.populationBuilderParameters;
    }

    public final void initNodeFactory() {
        NodeFactory factory = new NodeFactory();
        List<Leaf> terminals = factory.getTerminalSet();
        for (String c : this.constants) {
            terminals.add(new Constant(c));
        }
        for (String s : this.ranges) {
            terminals.add(new RegexRange(s));
        }
        List<Node> functions = factory.getFunctionSet();
        for (String o : this.operators) {
            try {
                functions.add(this.buildOperatorInstance(o));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                LOG.log(Level.SEVERE, "Unable to create required operator: " + o, ex);
                System.exit(1);
            }
        }
        this.nodeFactory = factory;
    }

    private Node buildOperatorInstance(String o) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<Node> operatorClass = Class.forName(o).asSubclass(Node.class);
        Node operator = operatorClass.newInstance();
        return operator;
    }

    public void updateObjective(String objectiveClass) {
        try {
            Objective operator;
            Class<Objective> operatorClass = Class.forName(objectiveClass).asSubclass(Objective.class);
            this.objective = operator = operatorClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOG.log(Level.SEVERE, "Unable to create required objective: " + objectiveClass, ex);
            System.exit(1);
        }
    }
}

