/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.objective.performance;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.evaluators.TreeEvaluator;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.objective.Objective;
import it.units.inginf.male.objective.performance.PerformancesFactory;
import it.units.inginf.male.outputs.FinalSolution;
import it.units.inginf.male.tree.Constant;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.utils.BasicStats;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PerformacesObjective
implements Objective {
    private Context context;

    @Override
    public void setup(Context context) {
        this.context = context;
    }

    @Override
    public double[] fitness(Node individual) {
        List<List<DataSet.Bounds>> evaluate;
        DataSet dataSetView = this.context.getCurrentDataSet();
        TreeEvaluator evaluator = this.context.getConfiguration().getEvaluator();
        double[] fitness = new double[6];
        try {
            evaluate = evaluator.evaluate(individual, this.context);
        }
        catch (TreeEvaluationException ex) {
            Logger.getLogger(PerformacesObjective.class.getName()).log(Level.SEVERE, null, ex);
            Arrays.fill(fitness, Double.POSITIVE_INFINITY);
            return fitness;
        }
        BasicStats statsOverall = new BasicStats();
        BasicStats statsCharsOverall = new BasicStats();
        int i = 0;
        for (List<DataSet.Bounds> result : evaluate) {
            BasicStats stats = new BasicStats();
            BasicStats statsChars = new BasicStats();
            DataSet.Example example = dataSetView.getExample(i);
            List<DataSet.Bounds> expectedMatchMask = example.getMatch();
            List<DataSet.Bounds> expectedUnmatchMask = example.getUnmatch();
            stats.tp = this.countIdenticalRanges(result, expectedMatchMask);
            stats.fp = (long)result.size() - stats.tp;
            statsChars.tp = this.intersection(result, expectedMatchMask);
            statsChars.fp = this.intersection(result, expectedUnmatchMask);
            statsOverall.add(stats);
            statsCharsOverall.add(statsChars);
            ++i;
        }
        statsCharsOverall.tn = (long)dataSetView.getNumberUnmatchedChars() - statsCharsOverall.fp;
        statsCharsOverall.fn = (long)dataSetView.getNumberMatchedChars() - statsCharsOverall.tp;
        double charAccuracy = statsCharsOverall.accuracy();
        double charPrecision = statsCharsOverall.precision();
        double charRecall = statsCharsOverall.recall();
        double precision = statsOverall.precision();
        double recall = statsOverall.recall(dataSetView.getNumberMatches());
        double fmeasure = 2.0 * (precision * recall) / (precision + recall);
        fitness[0] = precision;
        fitness[1] = recall;
        fitness[2] = charPrecision;
        fitness[3] = charRecall;
        fitness[4] = charAccuracy;
        fitness[5] = fmeasure;
        return fitness;
    }

    private int intersection(List<DataSet.Bounds> extractedRanges, List<DataSet.Bounds> expectedRanges) {
        int overallNumChars = 0;
        for (DataSet.Bounds extractedBounds : extractedRanges) {
            for (DataSet.Bounds expectedBounds : expectedRanges) {
                int numChars = Math.min(extractedBounds.end, expectedBounds.end) - Math.max(extractedBounds.start, expectedBounds.start);
                overallNumChars += Math.max(0, numChars);
            }
        }
        return overallNumChars;
    }

    private int countIdenticalRanges(List<DataSet.Bounds> rangesA, List<DataSet.Bounds> rangesB) {
        int identicalRanges = 0;
        block0: for (DataSet.Bounds boundsA : rangesA) {
            for (DataSet.Bounds boundsB : rangesB) {
                if (!boundsA.equals(boundsB)) continue;
                ++identicalRanges;
                continue block0;
            }
        }
        return identicalRanges;
    }

    @Override
    public TreeEvaluator getTreeEvaluator() {
        return this.context.getConfiguration().getEvaluator();
    }

    @Override
    public Objective cloneObjective() {
        return new PerformacesObjective();
    }

    public static void populatePerformancesMap(double[] performances, Map<String, Double> performancesMap) {
        performancesMap.put("match precision", performances[0]);
        performancesMap.put("match recall", performances[1]);
        performancesMap.put("character precision", performances[2]);
        performancesMap.put("character recall", performances[3]);
        performancesMap.put("character accuracy", performances[4]);
        performancesMap.put("match f-measure", performances[5]);
    }

    public static void populateFinalSolutionPerformances(Context.EvaluationPhases phase, Configuration configuration, FinalSolution finalSolution) {
        Objective phaseObjective = PerformancesFactory.buildObjective(phase, configuration);
        Constant finalTree = new Constant(finalSolution.getSolution());
        double[] phasePerformaceRoughtValues = phaseObjective.fitness(finalTree);
        Map<String, Double> phasePerformances = null;
        switch (phase) {
            case TRAINING: {
                phasePerformances = finalSolution.getTrainingPerformances();
                break;
            }
            case VALIDATION: {
                phasePerformances = finalSolution.getValidationPerformances();
                break;
            }
            case LEARNING: {
                phasePerformances = finalSolution.getLearningPerformances();
            }
        }
        PerformacesObjective.populatePerformancesMap(phasePerformaceRoughtValues, phasePerformances);
    }
}

