/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.outputs;

import com.google.gson.Gson;
import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.inputs.DataSet;
import it.units.inginf.male.outputs.FinalSolution;
import it.units.inginf.male.outputs.JobEvolutionTrace;
import it.units.inginf.male.utils.BasicStats;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Results {
    private String datasetName;
    private String methodDescription;
    private String comment;
    private Date experimentDate = new Date();
    private transient String machineHardwareSpecifications;
    private FinalSolution bestSolution;
    private List<List<DataSet.Bounds>> bestExtractions;
    private List<List<String>> bestExtractionsStrings;
    private List<DataSet.Example> examples;
    private List<BasicStats> bestExtractionsStats;
    private long overallExecutionTimeMillis;
    private int numberMatches;
    private int numberUnmatches;
    private int numberMatchedChars = 0;
    private int numberUnmatchedChars = 0;
    private int numberAnnotatedChars;
    private int numberAllChars;
    private int numberTrainingMatches;
    private int numberTrainingUnmatches;
    private long characterEvaluations = 0L;
    private transient Configuration configuration;
    private transient List<JobEvolutionTrace> jobEvolutionTrace;

    public Results(int numberOfJobs) {
        this.jobEvolutionTrace = new ArrayList<JobEvolutionTrace>(numberOfJobs);
        for (int i = 0; i < numberOfJobs; ++i) {
            this.jobEvolutionTrace.add(new JobEvolutionTrace());
        }
    }

    public Results(Configuration configuration) {
        this(configuration.getJobs());
        this.configuration = configuration;
        this.datasetName = this.configuration.getDatasetContainer().getDataset().getName();
        this.methodDescription = this.configuration.getConfigName();
    }

    public JobEvolutionTrace getJobTrace(int jobID) {
        return this.jobEvolutionTrace.get(jobID);
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getMethodDescription() {
        return this.methodDescription;
    }

    public void setMethodDescription(String methodDescription) {
        this.methodDescription = methodDescription;
    }

    public Date getExperimentDate() {
        return this.experimentDate;
    }

    public void setExperimentDate(Date experimentDate) {
        this.experimentDate = experimentDate;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getMachineHardwareSpecifications() {
        return this.machineHardwareSpecifications;
    }

    public void setMachineHardwareSpecifications(String machineHardwareSpecifications) {
        this.machineHardwareSpecifications = machineHardwareSpecifications;
    }

    public List<JobEvolutionTrace> getJobEvolutionTraces() {
        return this.jobEvolutionTrace;
    }

    public void setJobEvolutionTraces(List<JobEvolutionTrace> jobEvolutionTraces) {
        this.jobEvolutionTrace = jobEvolutionTraces;
    }

    public FinalSolution getBestSolution() {
        return this.bestSolution;
    }

    public void setBestSolution(FinalSolution bestSolution) {
        this.bestSolution = bestSolution;
    }

    public long getOverallExecutionTimeMillis() {
        return this.overallExecutionTimeMillis;
    }

    public void setOverallExecutionTimeMillis(long overallExecutionTimeMillis) {
        this.overallExecutionTimeMillis = overallExecutionTimeMillis;
    }

    public int getNumberMatches() {
        return this.numberMatches;
    }

    public void setNumberMatches(int numberMatches) {
        this.numberMatches = numberMatches;
    }

    public int getNumberUnmatches() {
        return this.numberUnmatches;
    }

    public void setNumberUnmatches(int numberUnatches) {
        this.numberUnmatches = numberUnatches;
    }

    public long getCharacterEvaluations() {
        return this.characterEvaluations;
    }

    public void addCharachterEvaluated(long numChars) {
        this.characterEvaluations += numChars;
    }

    public int getNumberMatchedChars() {
        return this.numberMatchedChars;
    }

    public void setNumberMatchedChars(int numberMatchedChars) {
        this.numberMatchedChars = numberMatchedChars;
        this.numberAnnotatedChars = this.numberMatchedChars + this.numberUnmatchedChars;
    }

    public int getNumberUnmatchedChars() {
        return this.numberUnmatchedChars;
    }

    public void setNumberUnmatchedChars(int numberUnmatchedChars) {
        this.numberUnmatchedChars = numberUnmatchedChars;
        this.numberAnnotatedChars = this.numberMatchedChars + this.numberUnmatchedChars;
    }

    public int getNumberAllChars() {
        return this.numberAllChars;
    }

    public void setNumberAllChars(int numberAllChars) {
        this.numberAllChars = numberAllChars;
    }

    public int getNumberAnnotatedChars() {
        return this.numberAnnotatedChars;
    }

    public int getNumberTrainingMatches() {
        return this.numberTrainingMatches;
    }

    public void setNumberTrainingMatches(int numberTrainingMatches) {
        this.numberTrainingMatches = numberTrainingMatches;
    }

    public int getNumberTrainingUnmatches() {
        return this.numberTrainingUnmatches;
    }

    public void setNumberTrainingUnmatches(int numberTrainingUnmatches) {
        this.numberTrainingUnmatches = numberTrainingUnmatches;
    }

    public List<List<DataSet.Bounds>> getBestExtractions() {
        return this.bestExtractions;
    }

    public void setBestExtractions(List<List<DataSet.Bounds>> bestExtractions) {
        this.bestExtractions = bestExtractions;
    }

    public List<List<String>> getBestExtractionsStrings() {
        return this.bestExtractionsStrings;
    }

    public void setBestExtractionsStrings(List<List<String>> bestExtractionsStrings) {
        this.bestExtractionsStrings = bestExtractionsStrings;
    }

    public List<DataSet.Example> getExamples() {
        return this.examples;
    }

    public void setExamples(List<DataSet.Example> examples) {
        this.examples = examples;
    }

    public List<BasicStats> getBestExtractionsStats() {
        return this.bestExtractionsStats;
    }

    public void setBestExtractionsStats(List<BasicStats> bestStats) {
        this.bestExtractionsStats = bestStats;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static Results load(String fileName) throws IOException {
        StringBuilder sb;
        FileInputStream fis = new FileInputStream(new File(fileName));
        InputStreamReader isr = new InputStreamReader(fis);
        try (BufferedReader bufferedReader = new BufferedReader(isr);){
            String line;
            sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
        }
        String json = sb.toString();
        Gson gson = new Gson();
        Results result = gson.fromJson(json, Results.class);
        return result;
    }
}

