/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.strategy.impl;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.evaluators.CachedEvaluator;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.objective.Objective;
import it.units.inginf.male.objective.Ranking;
import it.units.inginf.male.objective.performance.PerformacesObjective;
import it.units.inginf.male.objective.performance.PerformancesFactory;
import it.units.inginf.male.outputs.FinalSolution;
import it.units.inginf.male.outputs.JobEvolutionTrace;
import it.units.inginf.male.outputs.Results;
import it.units.inginf.male.strategy.ExecutionListener;
import it.units.inginf.male.strategy.ExecutionListenerFactory;
import it.units.inginf.male.strategy.ExecutionStrategy;
import it.units.inginf.male.strategy.RunStrategy;
import it.units.inginf.male.strategy.impl.DefaultExecutionListener;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class CoolTextualExecutionListener
implements ExecutionListener,
ExecutionListenerFactory {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_BLACK = "\u001b[30m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private static final String ANSI_PURPLE = "\u001b[35m";
    private static final String ANSI_CYAN = "\u001b[36m";
    private static final String ANSI_WHITE = "\u001b[37m";
    private static final Logger LOG = Logger.getLogger(DefaultExecutionListener.class.getName());
    private final Map<Integer, String> screen = new TreeMap<Integer, String>();
    private final Map<Integer, Long> jobStartTimes = new ConcurrentHashMap<Integer, Long>();
    private final NavigableSet<Integer> remove = new TreeSet<Integer>();
    private final String header;
    private int jobDone = 0;
    private int jobTotal = 0;
    private int overallDone = 0;
    private int overallTotal = 0;
    private final long startTime = System.currentTimeMillis();
    private String eta;
    private FinalSolution best = null;
    private final Results results;
    private boolean isEvaluatorCached = false;

    public CoolTextualExecutionListener(String message, Configuration configuration, Results results) {
        this.header = (message != null ? message.concat("\n") : "") + "Output folder: " + configuration.getOutputFolder().getName();
        this.jobTotal = configuration.getJobs();
        this.overallTotal = configuration.getEvolutionParameters().getGenerations() * this.jobTotal;
        this.results = results;
        if (configuration.getEvaluator() instanceof CachedEvaluator) {
            this.isEvaluatorCached = true;
        }
    }

    private synchronized void print() {
        char esc = '\u001b';
        String clear = esc + "[2J";
        System.out.print(clear);
        int doneAll = 20 * this.overallDone / this.overallTotal;
        double percAll = (double)Math.round((double)(1000 * this.overallDone) / (double)this.overallTotal) / 10.0;
        System.out.println(this.header);
        if (this.isEvaluatorCached) {
            CachedEvaluator evaluator = (CachedEvaluator)this.results.getConfiguration().getEvaluator();
            System.out.printf("[%s] %.2f%%  | %d/%d | ETA: %s | CR: %.2f\n", this.progress(doneAll), percAll, this.jobDone, this.jobTotal, this.eta, evaluator.getRatio());
        } else {
            System.out.printf("[%s] %.2f%%  | %d/%d | ETA: %s\n", this.progress(doneAll), percAll, this.jobDone, this.jobTotal, this.eta);
        }
        for (Integer jobId : this.screen.keySet()) {
            String color = "";
            if (this.remove.contains(jobId)) {
                color = ANSI_GREEN;
            }
            System.out.println(color + this.screen.get(jobId) + ANSI_RESET);
        }
        System.out.println("Best: \u001b[32m" + this.printRegex(this.best.getSolution()) + ANSI_RESET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evolutionStarted(RunStrategy strategy) {
        int jobId = strategy.getConfiguration().getJobId();
        String print = "[                     ] 0% Gen --> 0 job: " + jobId;
        Map<Integer, String> map = this.screen;
        synchronized (map) {
            this.screen.put(jobId, print);
        }
        this.jobStartTimes.put(jobId, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logGeneration(RunStrategy strategy, int generation, Node best, double[] fitness, List<Ranking> population) {
        int jobId = strategy.getConfiguration().getJobId();
        int done = 20 * generation / strategy.getConfiguration().getEvolutionParameters().getGenerations();
        double perc = (float)Math.round((double)(1000 * generation) / (double)strategy.getConfiguration().getEvolutionParameters().getGenerations()) / 10.0f;
        ++this.overallDone;
        long timeTakenPerGen = (System.currentTimeMillis() - this.startTime) / (long)this.overallDone;
        long elapsedMillis = (long)(this.overallTotal - this.overallDone) * timeTakenPerGen;
        this.eta = String.format("%d h, %d m, %d s", TimeUnit.MILLISECONDS.toHours(elapsedMillis), TimeUnit.MILLISECONDS.toMinutes(elapsedMillis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(elapsedMillis)), TimeUnit.MILLISECONDS.toSeconds(elapsedMillis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(elapsedMillis)));
        Ranking bestRanking = new Ranking(best, fitness);
        FinalSolution generationBestSolution = new FinalSolution(bestRanking);
        Objective learningObjective = PerformancesFactory.buildObjective(Context.EvaluationPhases.LEARNING, strategy.getConfiguration());
        double[] learningPerformance = learningObjective.fitness(population.get(0).getTree());
        PerformacesObjective.populatePerformancesMap(learningPerformance, generationBestSolution.getLearningPerformances());
        this.updateBest(generationBestSolution);
        String print = String.format("[%s] %.2f%% g: %d j: %d f: %s d: %.2f%% ", this.progress(done), perc, generation, jobId, this.printArray(fitness), Utils.diversity(population));
        Map<Integer, String> map = this.screen;
        synchronized (map) {
            this.screen.put(jobId, print);
            this.print();
        }
        this.results.addCharachterEvaluated(strategy.getContext().getCurrentDataSet().getNumberOfChars() * population.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evolutionComplete(RunStrategy strategy, int generation, List<Ranking> population) {
        int jobId = strategy.getConfiguration().getJobId();
        long executionTime = System.currentTimeMillis() - this.jobStartTimes.remove(jobId);
        int jumpedGenerations = strategy.getConfiguration().getEvolutionParameters().getGenerations() - generation;
        this.overallDone += jumpedGenerations;
        Map<Integer, String> map = this.screen;
        synchronized (map) {
            this.remove.add(jobId);
            if (this.screen.size() > 10) {
                this.screen.remove(this.remove.pollFirst());
            }
        }
        ++this.jobDone;
        if (this.jobDone >= strategy.getConfiguration().getJobs()) {
            this.print();
        }
        JobEvolutionTrace jobTrace = this.results.getJobTrace(jobId);
        jobTrace.setExecutionTime(executionTime);
        Objective trainingObjective = PerformancesFactory.buildObjective(Context.EvaluationPhases.TRAINING, strategy.getConfiguration());
        Objective validationObjective = PerformancesFactory.buildObjective(Context.EvaluationPhases.VALIDATION, strategy.getConfiguration());
        Objective learningObjective = PerformancesFactory.buildObjective(Context.EvaluationPhases.LEARNING, strategy.getConfiguration());
        for (int i = 0; i < population.size(); ++i) {
            Ranking individual = population.get(i);
            FinalSolution finalSolution = new FinalSolution(individual);
            if (i == 0) {
                double[] trainingPerformace = trainingObjective.fitness(individual.getTree());
                double[] validationPerformance = validationObjective.fitness(individual.getTree());
                double[] learningPerformance = learningObjective.fitness(individual.getTree());
                PerformacesObjective.populatePerformancesMap(trainingPerformace, finalSolution.getTrainingPerformances());
                PerformacesObjective.populatePerformancesMap(validationPerformance, finalSolution.getValidationPerformances());
                PerformacesObjective.populatePerformancesMap(learningPerformance, finalSolution.getLearningPerformances());
            }
            jobTrace.getFinalGeneration().add(finalSolution);
        }
    }

    @Override
    public void evolutionFailed(RunStrategy strategy, TreeEvaluationException cause) {
        int jobId = strategy.getConfiguration().getJobId();
    }

    private String progress(int done) {
        int i;
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < done; ++i) {
            builder.append("=");
        }
        if (done < 20) {
            builder.append(">");
            for (i = 19; i > done; --i) {
                builder.append(" ");
            }
        }
        return builder.toString();
    }

    @Override
    public void register(ExecutionStrategy strategy) {
    }

    @Override
    public ExecutionListener getNewListener() {
        return this;
    }

    private String printRegex(String regex) {
        if (regex.length() > 65) {
            return regex.substring(0, 64) + " [..]";
        }
        return regex;
    }

    private String printArray(double[] fitness) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append((float)Math.round(fitness[0] * 100.0) / 100.0f);
        for (int i = 1; i < fitness.length; ++i) {
            sb.append(",");
            sb.append((float)Math.round(fitness[i] * 100.0) / 100.0f);
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized void updateBest(FinalSolution candidate) {
        if (this.best == null) {
            this.best = candidate;
            return;
        }
        int index = 0;
        for (double value : this.best.getFitness()) {
            if (value > candidate.getFitness()[index]) {
                this.best = candidate;
                return;
            }
            if (value < candidate.getFitness()[index]) {
                return;
            }
            ++index;
        }
    }

    @Override
    public void evolutionStopped() {
    }
}

