/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.strategy.impl;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.configuration.EvolutionParameters;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.generations.InitialPopulationBuilder;
import it.units.inginf.male.generations.Ramped;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.objective.Objective;
import it.units.inginf.male.objective.Ranking;
import it.units.inginf.male.selections.Selection;
import it.units.inginf.male.selections.Tournament;
import it.units.inginf.male.strategy.ExecutionListener;
import it.units.inginf.male.strategy.RunStrategy;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.utils.Pair;
import it.units.inginf.male.utils.Utils;
import it.units.inginf.male.variations.Variation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultStrategy
implements RunStrategy {
    protected Context context;
    protected int maxDepth;
    protected List<Node> population;
    protected List<Ranking> rankings = new LinkedList<Ranking>();
    protected Selection selection;
    protected Objective objective;
    protected Variation variation;
    protected EvolutionParameters param;
    protected ExecutionListener listener;
    protected boolean terminationCriteria = false;
    protected int terminationCriteriaGenerations = 200;

    @Override
    public void setup(Configuration configuration, ExecutionListener listener) throws TreeEvaluationException {
        this.param = configuration.getEvolutionParameters();
        this.readParameters(configuration);
        this.context = new Context(Context.EvaluationPhases.TRAINING, configuration);
        this.maxDepth = this.param.getCreationMaxDepth();
        this.objective = configuration.getObjective();
        this.selection = new Tournament(this.context);
        this.variation = new Variation(this.context);
        this.listener = listener;
        this.objective.setup(this.context);
    }

    protected void readParameters(Configuration configuration) {
        Map<String, String> parameters = configuration.getStrategyParameters();
        if (parameters != null) {
            if (parameters.containsKey("terminationCriteriaGenerations")) {
                this.terminationCriteriaGenerations = Integer.valueOf(parameters.get("terminationCriteriaGenerations"));
            }
            if (parameters.containsKey("terminationCriteria")) {
                this.terminationCriteria = Boolean.valueOf(parameters.get("terminationCriteria"));
            }
        }
    }

    @Override
    public Void call() throws TreeEvaluationException {
        try {
            this.listener.evolutionStarted(this);
            InitialPopulationBuilder populationBuilder = this.context.getConfiguration().getPopulationBuilder();
            this.population = populationBuilder.init();
            Ramped ramped = new Ramped(this.maxDepth, this.context);
            this.population.addAll(ramped.generate(this.param.getPopulationSize() - this.population.size()));
            List<Ranking> tmp = this.buildRankings(this.population, this.objective);
            while (tmp.size() > 0) {
                List<Ranking> t = Utils.getFirstParetoFront(tmp);
                tmp.removeAll(t);
                this.sortByFirst(t);
                this.rankings.addAll(t);
            }
            String oldGenerationBestValue = null;
            int terminationCriteriaGenerationsCounter = 0;
            int doneGenerations = 0;
            for (int generation = 0; generation < this.param.getGenerations(); ++generation) {
                this.context.setStripedPhase(this.context.getDataSetContainer().isDataSetStriped() && generation % this.context.getDataSetContainer().getProposedNormalDatasetInterval() != 0);
                this.evolve();
                Ranking best = this.rankings.get(0);
                doneGenerations = generation + 1;
                if (this.listener != null) {
                    this.listener.logGeneration(this, doneGenerations, best.getTree(), best.getFitness(), this.rankings);
                }
                boolean allPerfect = true;
                for (double fitness : this.rankings.get(0).getFitness()) {
                    if (Math.round(fitness * 10000.0) == 0L) continue;
                    allPerfect = false;
                    break;
                }
                if (allPerfect) break;
                if (this.terminationCriteria) {
                    String newBestValue = best.getDescription();
                    terminationCriteriaGenerationsCounter = newBestValue.equals(oldGenerationBestValue) ? ++terminationCriteriaGenerationsCounter : 0;
                    if (terminationCriteriaGenerationsCounter >= this.terminationCriteriaGenerations) break;
                    oldGenerationBestValue = newBestValue;
                }
                if (Thread.interrupted()) break;
            }
            if (this.listener != null) {
                this.listener.evolutionComplete(this, doneGenerations, this.rankings);
            }
            return null;
        }
        catch (Throwable x) {
            throw new TreeEvaluationException("Error during evaluation of a tree", x, this);
        }
    }

    protected void evolve() {
        ArrayList<Node> newPopulation = new ArrayList<Node>(this.population.size());
        int popSize = this.population.size();
        int oldPopSize = (int)((double)popSize * 0.9);
        boolean allPerfect = true;
        for (double fitness : this.rankings.get(0).getFitness()) {
            if (Math.round(fitness * 10000.0) == 0L) continue;
            allPerfect = false;
            break;
        }
        if (allPerfect) {
            return;
        }
        for (int index = 0; index < this.param.getElitarism(); ++index) {
            Node elite = this.rankings.remove(0).getTree();
            newPopulation.add(elite);
        }
        while (newPopulation.size() < oldPopSize) {
            double random = this.context.getRandom().nextDouble();
            if (random <= (double)this.param.getCrossoverProbability() && oldPopSize - newPopulation.size() >= 2) {
                Node selectedB;
                Node selectedA = this.selection.select(this.rankings);
                Pair<Node, Node> newIndividuals = this.variation.crossover(selectedA, selectedB = this.selection.select(this.rankings));
                if (newIndividuals == null) continue;
                newPopulation.add(newIndividuals.getFirst());
                newPopulation.add(newIndividuals.getSecond());
                continue;
            }
            if (random <= (double)(this.param.getCrossoverProbability() + this.param.getMutationPobability())) {
                Node mutant = this.selection.select(this.rankings);
                mutant = this.variation.mutate(mutant);
                newPopulation.add(mutant);
                continue;
            }
            Node duplicated = this.selection.select(this.rankings);
            newPopulation.add(duplicated);
        }
        Ramped ramped = new Ramped(this.maxDepth, this.context);
        List<Node> generated = ramped.generate(popSize - oldPopSize);
        newPopulation.addAll(generated);
        this.population = newPopulation;
        List<Ranking> tmp = this.buildRankings(this.population, this.objective);
        this.rankings.clear();
        while (tmp.size() > 0) {
            List<Ranking> t = Utils.getFirstParetoFront(tmp);
            tmp.removeAll(t);
            this.sortByFirst(t);
            this.rankings.addAll(t);
        }
    }

    protected List<Ranking> buildRankings(List<Node> population, Objective objective) {
        ArrayList<Ranking> result = new ArrayList<Ranking>(population.size());
        for (Node tree : population) {
            double[] fitness = objective.fitness(tree);
            result.add(new Ranking(tree, fitness));
        }
        return result;
    }

    @Override
    public Configuration getConfiguration() {
        return this.context.getConfiguration();
    }

    @Override
    public ExecutionListener getExecutionListener() {
        return this.listener;
    }

    protected void sortByFirst(List<Ranking> front) {
        Collections.sort(front, new Comparator<Ranking>(){

            @Override
            public int compare(Ranking o1, Ranking o2) {
                Double fitness1 = o1.getFitness()[0];
                Double fitness2 = o2.getFitness()[0];
                int result = Double.compare(fitness1, fitness2);
                if (result == 0) {
                    return o1.getDescription().compareTo(o2.getDescription());
                }
                return result;
            }
        });
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

