/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.strategy.impl;

import it.units.inginf.male.configuration.Configuration;
import it.units.inginf.male.evaluators.TreeEvaluationException;
import it.units.inginf.male.strategy.ExecutionListenerFactory;
import it.units.inginf.male.strategy.RunStrategy;
import it.units.inginf.male.strategy.impl.AbstractExecutionStrategy;
import java.util.Map;

public class SinglethreadStrategy
extends AbstractExecutionStrategy {
    private Thread workThread;
    private boolean done = false;

    @Override
    public void execute(Configuration configuration, ExecutionListenerFactory listenerFactory) throws Exception {
        listenerFactory.register(this);
        this.workThread = Thread.currentThread();
        Map<String, String> parameters = configuration.getStrategyParameters();
        Class<? extends RunStrategy> strategyClass = this.getStrategy(parameters);
        long initialSeed = configuration.getInitialSeed();
        for (int i = 0; i < configuration.getJobs() && !this.done; ++i) {
            RunStrategy job = strategyClass.newInstance();
            Configuration jobConf = new Configuration(configuration);
            jobConf.setJobId(i);
            jobConf.setInitialSeed(initialSeed + (long)i);
            job.setup(jobConf, listenerFactory.getNewListener());
            try {
                job.call();
                continue;
            }
            catch (TreeEvaluationException ev) {
                job.getExecutionListener().evolutionFailed(job, ev);
            }
        }
    }

    @Override
    public void shutdown() {
        this.done = true;
        this.workThread.interrupt();
    }
}

