/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Range
implements Comparable<Range> {
    private int startIndex;
    private int endIndex;

    public Range(int startIndex, int endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getLength() {
        return this.endIndex - this.startIndex + 1;
    }

    public static List<Range> compactRanges(List<Range> ranges) {
        LinkedList<Range> newRanges = new LinkedList<Range>();
        if (ranges.isEmpty()) {
            return newRanges;
        }
        Collections.sort(ranges);
        Range prevRange = new Range(ranges.get((int)0).startIndex, ranges.get((int)0).endIndex);
        for (int i = 1; i < ranges.size(); ++i) {
            Range currentRange = ranges.get(i);
            if (currentRange.startIndex == prevRange.endIndex + 1) {
                prevRange.endIndex = currentRange.endIndex;
                continue;
            }
            newRanges.add(prevRange);
            prevRange = new Range(currentRange.startIndex, currentRange.endIndex);
        }
        newRanges.add(prevRange);
        return newRanges;
    }

    @Override
    public int compareTo(Range o) {
        return this.startIndex - o.startIndex;
    }
}

