/*
 * Decompiled with CFR 0.152.
 */
package it.units.inginf.male.variations;

import it.units.inginf.male.configuration.EvolutionParameters;
import it.units.inginf.male.generations.Generation;
import it.units.inginf.male.generations.Growth;
import it.units.inginf.male.inputs.Context;
import it.units.inginf.male.tree.Leaf;
import it.units.inginf.male.tree.Node;
import it.units.inginf.male.tree.operator.Group;
import it.units.inginf.male.tree.operator.NonCapturingGroup;
import it.units.inginf.male.utils.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Variation {
    private Context context;
    private Generation growth;

    public Variation(Context context) {
        this.context = context;
        this.growth = new Growth(5, context);
    }

    public Pair<Node, Node> crossover(Node individualA, Node individualB) {
        boolean isGood = false;
        Node newIndividualA = null;
        Node newIndividualB = null;
        for (int tries = 0; tries < 20; ++tries) {
            newIndividualA = individualA.cloneTree();
            newIndividualB = individualB.cloneTree();
            Node randomNodeA = this.pickRandomNode(newIndividualA);
            Node randomNodeB = this.pickRandomNode(newIndividualB);
            if (randomNodeA == null || randomNodeB == null) continue;
            Node aParent = randomNodeA.getParent();
            List<Node> aChilds = aParent.getChildrens();
            int aIndex = aChilds.indexOf(randomNodeA);
            Node bParent = randomNodeB.getParent();
            List<Node> bChilds = bParent.getChildrens();
            int bIndex = bChilds.indexOf(randomNodeB);
            aChilds.set(aIndex, randomNodeB);
            bChilds.set(bIndex, randomNodeA);
            randomNodeA.setParent(bParent);
            randomNodeB.setParent(aParent);
            if (!this.checkMaxDepth(newIndividualA, 1) || !this.checkMaxDepth(newIndividualB, 1) || !newIndividualA.isValid() || !newIndividualB.isValid()) continue;
            isGood = true;
            break;
        }
        if (isGood) {
            return new Pair<Node, Node>(newIndividualA, newIndividualB);
        }
        return null;
    }

    public Node mutate(Node individual) {
        List<Node> newNodes = this.growth.generate(20);
        Node mutant = individual.cloneTree();
        for (Node newNode : newNodes) {
            Node randomNode = this.pickRandomNode(mutant);
            if (randomNode != null) {
                this.replaceNode(mutant, randomNode, newNode);
                if (this.checkMaxDepth(mutant, 1) && mutant.isValid()) break;
            }
            mutant = individual.cloneTree();
        }
        return mutant;
    }

    private Node pickRandomNode(Node individual) {
        EvolutionParameters param = this.context.getConfiguration().getEvolutionParameters();
        ArrayList<Node> nodeList = new ArrayList<Node>();
        float random = this.context.getRandom().nextFloat();
        if (random <= param.getNodeCrossoverSelectionProbability()) {
            this.enlistNode(individual, nodeList, false);
        } else if (random <= param.getNodeCrossoverSelectionProbability() + param.getLeafCrossoverSelectionProbability()) {
            this.enlistNode(individual, nodeList, true);
        } else {
            nodeList.add(individual);
        }
        if (nodeList.isEmpty()) {
            this.enlistNode(individual, nodeList, true);
        }
        if (nodeList.isEmpty()) {
            return null;
        }
        int randomIndex = this.context.getRandom().nextInt(nodeList.size());
        return (Node)nodeList.get(randomIndex);
    }

    private void enlistNode(Node root, List<Node> nodes, boolean isLeaf) {
        if (this.isNodePickable(root, isLeaf)) {
            nodes.add(root);
        }
        for (Node child : root.getChildrens()) {
            this.enlistNode(child, nodes, isLeaf);
        }
    }

    private boolean isNodePickable(Node root, boolean isLeaf) {
        return !(root instanceof Leaf ^ isLeaf) && root.getParent() != null;
    }

    private void replaceNode(Node root, Node oldChild, Node newChild) {
        Node parent = oldChild.getParent();
        List<Node> childs = parent.getChildrens();
        int index = childs.indexOf(oldChild);
        newChild.setParent(parent);
        oldChild.setParent(null);
        childs.set(index, newChild);
    }

    private void swapNodes(Node a, Node b) {
        Node aParent = a.getParent();
        List<Node> aChilds = aParent.getChildrens();
        int aIndex = aChilds.indexOf(a);
        Node bParent = b.getParent();
        List<Node> bChilds = bParent.getChildrens();
        int bIndex = bChilds.indexOf(b);
        aChilds.set(aIndex, b);
        bChilds.set(bIndex, a);
        a.setParent(bParent);
        b.setParent(aParent);
    }

    private boolean checkMaxDepth(Node root, int depth) {
        if (depth > this.context.getConfiguration().getEvolutionParameters().getMaxDepthAfterCrossover()) {
            return false;
        }
        if (root instanceof Leaf) {
            return true;
        }
        boolean ret = true;
        for (Node child : root.getChildrens()) {
            ret &= this.checkMaxDepth(child, depth + 1);
        }
        return ret;
    }

    private void checkSingleGroup(Node root, List<Group> groups) {
        if (root instanceof Group) {
            groups.add((Group)root);
        }
        for (Node child : root.getChildrens()) {
            this.checkSingleGroup(child, groups);
        }
    }

    private Node normalizeGroup(Node root) {
        LinkedList<Group> groups = new LinkedList<Group>();
        this.checkSingleGroup(root, groups);
        if (groups.size() < 2) {
            return root;
        }
        int nextInt = this.context.getRandom().nextInt(groups.size());
        groups.remove(nextInt);
        for (Group group : groups) {
            NonCapturingGroup ncg = new NonCapturingGroup();
            if (group != root) {
                ncg.setParent(group.getParent());
                int indexOf = ncg.getParent().getChildrens().indexOf(group);
                ncg.getParent().getChildrens().set(indexOf, ncg);
            } else {
                root = ncg;
            }
            ncg.getChildrens().addAll(group.getChildrens());
            ncg.getChildrens().get(0).setParent(ncg);
        }
        return root;
    }
}

