import cv2
import shutil
import os

input_folder = './data/boxes_6dof_colmap_easy/images_old'
output_folder = './data/boxes_6dof_colmap_easy/images_true'


if not os.path.exists(output_folder):
    os.makedirs(output_folder)


input_files = os.listdir(input_folder)


# for i, filename in enumerate(input_files):
for i in range(0, len(input_files),1):

    filename = input_files[i]
    input_file_path = os.path.join(input_folder, filename)
    

    output_filename = '{:05d}.{}'.format(i, "png")
    # output_filename = '{:05d}.{}'.format(i+3, "png")
    # output_filename = '{:05d}.{}'.format(i+5, "png")
    

    output_file_path = os.path.join(output_folder, output_filename)
    

    shutil.copy(input_file_path, output_file_path)
    print(f'Copied {filename} to {output_filename}')

print('All files copied successfully.')