import cv2
import numpy as np


image1 = cv2.imread("D:/2024/3DGS/PureEventFilter/data/boxes_6dof_colmap_easy/output_images/00110.png", cv2.IMREAD_GRAYSCALE)
image2 = cv2.imread("D:/2024/3DGS/PureEventFilter/data/boxes_6dof_colmap_easy/output_images/00111.png", cv2.IMREAD_GRAYSCALE)


if image1 is None or image2 is None:
    print("Error: Could not read one or both images.")
    exit()


if image1.shape != image2.shape:
    print("Error: Images must have the same dimensions.")
    exit()


diff = image1.astype(np.int16) - image2.astype(np.int16)


positive_diff = np.zeros_like(diff, dtype=np.uint8)
negative_diff = np.zeros_like(diff, dtype=np.uint8)


positive_diff[diff > 0] = diff[diff > 0]
negative_diff[diff < 0] = -diff[diff < 0]


cv2.imwrite('positive_diff.png', positive_diff)
cv2.imwrite('negative_diff.png', negative_diff)


cv2.imshow('Positive Difference', positive_diff)
cv2.imshow('Negative Difference', negative_diff)
cv2.waitKey(0)
cv2.destroyAllWindows()