import os

from .utils import Datum, DatasetBase, read_json


template = ['a photo of a {}, a type of pet.']

class OxfordPets(DatasetBase):

    dataset_dir = 'oxford_pets'

    def __init__(self, root):
        self.dataset_dir = os.path.join(root, self.dataset_dir)
        self.image_dir = os.path.join(self.dataset_dir, 'images')
        self.anno_dir = os.path.join(self.dataset_dir, 'annotations')
        self.split_path = "split_zhou_OxfordPets.json"

        self.template = template

        test = self.read_split(self.split_path, self.image_dir)

        super().__init__(test=test)
    
    @staticmethod
    def read_split(filepath, path_prefix):
        def _convert(items):
            out = []
            for impath, label, classname in items:
                impath = os.path.join(path_prefix, impath)
                item = Datum(
                    impath=impath,
                    label=int(label),
                    classname=classname
                )
                out.append(item)
            return out
        
        print(f'Reading split from {filepath}')
        split = read_json(filepath)
        test = _convert(split['test'])

        return test