MODEL_PATH=/your_model_path/Llama-2-13b-hf
MODEL_NAME=llama-2-13b
TEMP=0.0 # 0.2 for general tasks and 0.6 for code generation
TOP_P=0.95 # 0.85 for general tasks and 0.95 for code generation
DATA_NUM=50
SEED=42
GPU_DEVICES=0
MAX_NEW_TOKENS=64

# SWIFT Hyperparameters
SEARCH_INTERVAL=5
BAYES_INTERVAL=50
MAX_SEARCH_ITER=1000
MAX_TOLERANCE_ITER=300
MAX_SCORE=0.95
CONTEXT_WINDOW=25
SKIP_RATIO=0.45
TASK_NAME="cnndm"

torch_dtype="float16"

CUDA_VISIBLE_DEVICES=${GPU_DEVICES} python -m evaluation_llama.inference_baseline --model-path $MODEL_PATH --model-id ${MODEL_NAME} --max-new-tokens ${MAX_NEW_TOKENS} --task-name ${TASK_NAME} --data-num ${DATA_NUM} --temperature $TEMP --top-p ${TOP_P} --seed ${SEED} --dtype $torch_dtype

CUDA_VISIBLE_DEVICES=${GPU_DEVICES} python -m evaluation_llama.inference_swift --model-path $MODEL_PATH --model-id ${MODEL_NAME} \
  --temperature $TEMP --top-p ${TOP_P} --dtype $torch_dtype --task-name ${TASK_NAME} --data-num ${DATA_NUM} --max-new-tokens ${MAX_NEW_TOKENS} \
  --seed $SEED --context-window ${CONTEXT_WINDOW} --search-interval ${SEARCH_INTERVAL} --bayes-interval ${BAYES_INTERVAL} \
  --max-search-iter ${MAX_SEARCH_ITER} --max-tolerance-iter ${MAX_TOLERANCE_ITER} --max-score ${MAX_SCORE} --skip-ratio ${SKIP_RATIO} --do-search --bayes
