# TSW-SL

## Requirements
To install the required python packages, run
```
pip install -r requirements.txt
```

## What is included?
* Gradient flow 
* Color Transfer
* Generative_models


## Gradient flow 
```
cd Gradient_flow/Run
python GradientFlow.py
```

## Color Transfer

```
cd ColorTransfer
python main.py --source [source image] --target [target image] --cluster --lr_tw=16. --n_lines_tw=4 --num_iter=2000 --num_iter_tw=2000 --std=0.1

```

## Generative_models
This code is run using Python 3.9.12.
### Code organization
* cfg.py : this file contains arguments for training.
* datasets.py : this file implements dataloaders.
* functions.py : this file implements training functions.
* trainsw.py : this file is the main file for running.
* models : this folder contains neural networks architecture.
* utils : this folder contains implementation of fid score and Inception score.

### Download FID Statistics
First of all, download the FID Statistics at this link: https://github.com/UT-Austin-Data-Science-Group/CSW/tree/main/fid_stat
Put this in the folder Generative models and then unzip it.

### Script examples
CIFAR10
```
GPU=1
seed=1
L=50
CUDA_VISIBLE_DEVICES=${GPU} taskset --cpu-list ${GPU}0-${GPU}9 python3 trainsw.py -gen_bs 128 -dis_bs 128 --dataset cifar10 --img_size 32 --max_iter 100000 --model sngan_cifar10 --latent_dim 128 --gf_dim 256 --df_dim 128 --g_spectral_norm False --d_spectral_norm True --g_lr 0.0002 --d_lr 0.0002 --beta1 0.0 --beta2 0.9 --init_type xavier_uniform --n_critic 5 --val_freq 50 --L ${L} --sw_type sw --random_seed ${seed} --exp_name SW_L${L}_seed${seed}
CUDA_VISIBLE_DEVICES=${GPU} taskset --cpu-list ${GPU}0-${GPU}9 python3 trainsw.py -gen_bs 128 -dis_bs 128 --dataset cifar10 --img_size 32 --max_iter 100000 --model sngan_cifar10 --latent_dim 128 --gf_dim 256 --df_dim 128 --g_spectral_norm False --d_spectral_norm True --g_lr 0.0002 --d_lr 0.0002 --beta1 0.0 --beta2 0.9 --init_type xavier_uniform --n_critic 5 --val_freq 50 --L ${L} --sw_type tw --random_seed ${seed} --fixed_trees True --mass_division uniform --type_lines sequence_of_lines --nlines 3 --exp_name TW_L${L}_seed${seed}
```

CelebA
```
GPU=1
seed=1
L=50
CUDA_VISIBLE_DEVICES=${GPU} taskset --cpu-list ${GPU}0-${GPU}9 python3 trainsw.py -gen_bs 128 -dis_bs 128 --dataset celeba --img_size 64 --max_iter 50000 --model sngan_celeba --latent_dim 128 --gf_dim 256 --df_dim 128 --g_spectral_norm False --d_spectral_norm True --g_lr 0.0002 --d_lr 0.0002 --beta1 0.0 --beta2 0.9 --init_type xavier_uniform --n_critic 5 --val_freq 20 --L ${L} --sw_type sw --random_seed ${seed} --exp_name SW_L${L}_seed${seed}
CUDA_VISIBLE_DEVICES=${GPU} taskset --cpu-list ${GPU}0-${GPU}9 python3 trainsw.py -gen_bs 128 -dis_bs 128 --dataset celeba --img_size 64 --max_iter 500000 --model sngan_celeba --latent_dim 128 --gf_dim 256 --df_dim 128 --g_spectral_norm False --d_spectral_norm True --g_lr 0.0002 --d_lr 0.0002 --beta1 0.0 --beta2 0.9 --init_type xavier_uniform --n_critic 5 --val_freq 1 --L ${L} --sw_type tw --random_seed ${seed} --fixed_trees True --mass_division uniform --type_lines sequence_of_lines --nlines 3 --exp_name TW_L${L}_seed${seed}
```
STL-10
```
GPU=1
seed=1
L=50
CUDA_VISIBLE_DEVICES=${GPU} taskset --cpu-list ${GPU}0-${GPU}9 python3 trainsw.py -gen_bs 128 -dis_bs 128 --dataset stl10 --img_size 64 --max_iter 50000 --model sngan_stl10 --latent_dim 128 --gf_dim 256 --df_dim 128 --g_spectral_norm False --d_spectral_norm True --g_lr 0.0002 --d_lr 0.0002 --beta1 0.0 --beta2 0.9 --init_type xavier_uniform --n_critic 5 --val_freq 20 --L ${L} --sw_type sw --random_seed ${seed} --exp_name SW_L${L}_seed${seed}
CUDA_VISIBLE_DEVICES=${GPU} taskset --cpu-list ${GPU}0-${GPU}9 python3 trainsw.py -gen_bs 128 -dis_bs 128 --dataset stl10 --img_size 64 --max_iter 500000 --model sngan_stl10 --latent_dim 128 --gf_dim 256 --df_dim 128 --g_spectral_norm False --d_spectral_norm True --g_lr 0.0002 --d_lr 0.0002 --beta1 0.0 --beta2 0.9 --init_type xavier_uniform --n_critic 5 --val_freq 1 --L ${L} --sw_type tw --random_seed ${seed} --fixed_trees True --mass_division uniform --type_lines sequence_of_lines --nlines 3 --exp_name TW_L${L}_seed${seed}
```

## Denoising diffusion models: Please refer to the readme.md at TSW-SL/denoising-diffusion-gan





