Replication code for the paper "Black-Box Combinatorial Optimization with Order-Invariant Reinforcement Learning"


## Requirements

The algorithm is in Python 3.11.5. 
All the library required to launch the multivariate RL EDAs are in the file requirement.txt.

Other libraries are required such as Nevergrad (see https://facebookresearch.github.io/nevergrad/) to run the competing algorithms.


## (sigma,simga')-RL-EDA algorithm

An example of python command to run the (sigma,simga')-RL-EDA version (reference version of the paper) with default hyperparameters for 10 QUBO instances  with n=128 and K=0 and 10 restarts for each instance (100 runs) on GPU device is :

python main_ppo_eda.py QUBO 128 0 --verbose 


## Nevergrad competing algorithms

To run a nervergrad algorithm such as DiscreteDE the command line is :

python main_nevergrad.py QUBO DiscreteDE 128 0


## Other EDAs and Tabu algorithms

To run the Tabu algorithm on the same instances the command line is

python main_baseline_edas_and_tabu.py QUBO Tabu 128 0

To run the PBIL algorithm on the same instance the command line is

python main_baseline_edas_and_tabu.py QUBO PBIL 128 0


