function [C,info] = fmW(M,N,G,F,params)
    k_eigM = numel(M.evals);  k_eigN = numel(N.evals); 
    A = N.evecs\F;
    B = M.evecs\G;
    [W] = eigs_mask(N,M,params.mask_algorithm);
    C_init = (max(max(W))-W)./max(max(W));
    k = size(N.evecs,2); % size(M.evecs,2);
    est_rank = min(sum(N.evals-max(M.evals)<0),sum(M.evals-max(N.evals)<0));
    d=zeros(1,k);
    d(1:est_rank)=1;
    D = repmat(d,size(M.evecs,2),1); %  repmat(d,k,1);

    % compute operator from desciptors
%     numDescr = size(F,2);
%     OpN = cell(numDescr,1);
%     OpM = cell(numDescr,1);
%     for i_Descr = 1:numDescr    
%             OpN{i_Descr} = N.evecs\(repmat(F(:,i_Descr), [1,k_eigN]).*N.evecs);
%             OpM{i_Descr} = M.evecs\(repmat(G(:,i_Descr), [1,k_eigM]).*M.evecs);
%     end

    manifold = euclideanfactory(k_eigM,k_eigN);
    problem = {}; options={};
    
    problem.M = manifold;
    problem.termFM = @(C) params.mu0 * (sum(sum((C*A-B).^2).^0.5));
    problem.termW = @(C) (params.mu1 * norm(C.*W,'fro')^2);
    problem.termOrtho = @(C) (params.mu2 * (norm(C'*C,'fro')^2 - sum(diag(C'*C).^2) + sum((diag(C'*C) - d').^2) ));
%     problem.termComm = @(C) (params.mu3*sum(cell2mat(cellfun(@(X,Y) sum((C*X - Y*C).^2,'all'), OpN, OpM, 'UniformOutput', false)),'all')/2) ;
    problem.cost = @(C) (problem.termFM(C) + problem.termW(C) + problem.termOrtho(C));
    
    problem.gradFM = @(C) (norm_21_gradient_rectangular(C,A,B));
    problem.gradW = @(C) (params.mu1 * 2 * C.*W.*W);
    problem.gradOrtho = @(C) (params.mu2 * 4*(C*C'*C - C.*D ));    
%     problem.gradComm = @(C) (params.mu3 * cell_sum(cellfun(@(X,Y) (Y'*(Y*C - C*X) - (Y*C - C*X)*X'), OpN, OpM, 'UniformOutput', false)));
    problem.egrad = @(C) (problem.gradFM(C) + problem.gradW(C) + problem.gradOrtho(C));

    options.maxiter = 1e4;
    options.tolgradnorm = 1e-06;
    options.minstepsize = 1e-06;
    options.verbosity = 1;
    options.statsfun = @fm_statfun;

    [C, final_cost, info, ~] = conjugategradient(problem, C_init, options); % C_init Cstruct.fmComm
    fprintf('C fmWcomm, iterations: %d, cost: %f\n', info(end).iter, final_cost);
       
    switch params.refinement
    case "icp_partial"
        [C, matches] = run_icp_partial(M, N, est_rank, C, params.refinement_max_iter);
        [C,~] = zoom_out_rect(M,N, C,k_eigM-size(C,1),k_eigN-size(C,2));
    case "icp"
        [C, matches] = run_icp_partial(M, N,min(k_eigM,k_eigN), C, params.refinement_max_iter);
        [C,~] = zoom_out_rect(M,N, C,k_eigM-size(C,1),k_eigN-size(C,2));
    case "zoomout"
        Co = C(1:fix(k_eigM*3/4),1:fix(k_eigN*3/4));
        [C,~] = zoom_out_rect(M,N, Co,k_eigM-size(Co,1),k_eigN-size(Co,2));
    end
    
    if nargout == 1
        clear info
    end
end

