function stats = fm_statfun(problem, C, stats)
    % energy
    pattern = "term";
    fields =  fieldnames(problem);
    samples = regexp(fields,pattern); 
    samples = fields(cellfun(@(x) ~isempty(x) && x == 1,samples));
    n_samples = size(samples,1);
    
    for i = 1:n_samples
        stats.(samples{i}) = problem.(samples{i})(C);
    end
    % gradient
    pattern = "grad";
    fields =  fieldnames(problem);
    samples = regexp(fields,pattern); 
    samples = fields(cellfun(@(x) ~isempty(x) && x == 1,samples));
    n_samples = size(samples,1);
    
    for i = 1:n_samples
        stats.(samples{i}) = norm(problem.(samples{i})(C),'fro');
    end
end