function [M1,M2] = load_mesh_pair(name,partiality_type,index)
% M = struct(TRIV,VERT,name)
switch name
    case {'cat','dog'}
        switch partiality_type
            case {'cuts','holes'}
            [M1,M2] = load_shrec16(name,partiality_type,index);
        end
otherwise
        error("datasetLoader: %s is not implemented\n",name);
end

end

function [M1,M2] = load_shrec16(name,partiality_type,index)
M1 = load(sprintf('./data/MESH/shrec2016/pointwise_gt/%s_%s_shape_%i.mat','cuts',name,1)).M;
M1.name = [name];
M2 = load(sprintf('./data/MESH/shrec2016/pointwise_gt/%s_%s_shape_%i.mat',partiality_type,name,index)).N;
M2.name = [name '_' partiality_type '_' int2str(index)];
M1.n = size(M1.VERT,1);
M2.n = size(M2.VERT,1);
end

