function M = datasetLoader(dataset, model)
    switch dataset
        case "karate"
            M = karateLoader(model);
        case "minnesota"
            M = minnesotaLoader(model);
        case "cat"
            M = catLoader(model);
        case "cora"
            M = CORALoader(model);
        case {"citeseer","amazon","amazonPhoto","amazonComputer"}
            M = amazonLoader(dataset);
        otherwise
            error("datasetLoader: %s is not implemented\n",dataset);
    end
    M.A = logical(M.A);
end
        
function M = karateLoader(model)
    M.A = load('./data/karate.mat');
    M.A = M.A.Problem.A;
    M.n = size(M.A,1);
    M.name = "Karate";
end

function M = amazonLoader(model)
    M = load(sprintf("data/%s//M.mat",model));
    M.n = size(M.A,1);
    M.name = model;
end

function M = catLoader(models_name)
    M = load_off('./data/cat.off');
    M.A = calc_adj_matrix(M, 1);
    M.n = size(M.A,1);
    M.name = "cat";
end

function M = minnesotaLoader(model_name)
    G = load('minnesota.mat').G;
    M.n = size(G.Nodes,1);
    M.A = sparse(M.n,M.n);
    edges = G.Edges.EndNodes;
    M.A(sub2ind(size(M.A), edges(:,1), edges(:,2))) = 1;
    M.A(sub2ind(size(M.A), edges(:,2), edges(:,1))) = 1;
    M.coords = table2array(G.Nodes);
    M.name = "minnesota";
end

function M = CORALoader(model)
    M = load('./data/cora.mat').M;
    M.name = "cora";
end