function [L] = graphNorm_laplacian(M,k)
    L.D = spdiags(sum(M.A,2),0,M.n,M.n);
%     L.L = L.D - M.A;
    % Lnorm = L.D^(-1/2) * L.L * L.D^(-1/2)= speye(size(L.D)) - L.D^(-1/2) * M.A * L.D^(-1/2)
%     L.L = speye(size(M.A)) - diag(sparse(-1)./sum(M.A,2)) * M.A; 
        
%    [L.evecs, L.evals] = eigs(L.L*L.D^(-1/2),L.D^(1/2), k, -1e-5);

%     L.L = speye(size(L.D)) - L.D^(-1/2) * M.A * L.D^(-1/2);
    Dinv = L.D^(1/2);
    L.L = speye(size(L.D)) - Dinv \ M.A / Dinv;
    
    % ensure symmetry
    L.L = (L.L + L.L')/2;


    [L.evecs, L.evals] = eigs(L.L, k, -1e-5);
    L.evals = diag(L.evals);
    if ~isreal(L.evals)
        fprintf("Warning: eigenvalues with imaginary part\n");
        if ~any(abs(imag(L.evals))>1e-15)
            L.evals = real(L.evals);
            L.evecs = real(L.evecs);
        else
            error("Imaginary part is not zero");
        end
    end
end

