function [W] = eigs_mask(N,M,mask_type)
switch mask_type
    case 'standard' % the standard Laplacian Mask
        Ev1 = N.evals;
        numEigsSrc = numel(N.evals);
        Ev2 = M.evals;
        numEigsTar = numel(M.evals);
        W = (repmat(Ev2, [1,numEigsSrc]) - repmat(Ev1', [numEigsTar,1])).^2;
        W = W/norm(W, 'fro');
    case 'complRes' % the complex resolvent Laplacian Mask
        sigma = 0.5;
        Ev1 = real(N.evals.^sigma);
        Ev2 = real(M.evals.^sigma);
        
        % complex part
        x1 = Ev2./(1 + Ev2.^2);
        x2 = Ev1'./(1+ Ev1'.^2);
        Dlb1 = (repmat(x1, [1,size(N.evecs,2)]) - repmat(x2, [size(M.evecs,2),1])).^2;
        
        % real part
        x1 = 1./(1 + Ev2.^2);
        x2 = 1./(1+ Ev1'.^2);
        Dlb2 = (repmat(x1, [1,size(N.evecs,2)]) - repmat(x2, [size(M.evecs,2),1])).^2;
        % equal weight
        W = Dlb1 + Dlb2;
        W = W/norm(W,'fro');
        
    case 'partial' 
        k = size(N.evecs,2); % size(M.evecs,2);
        est_rank = min(sum(N.evals-max(M.evals)<0),sum(M.evals-max(N.evals)<0));
        d=zeros(1,k);
        d(1:est_rank)=1;
        D = repmat(d,size(M.evecs,2),1); %  repmat(d,k,1);

         gamma = 1.5;
        W0 = pdist2(M.evals, N.evals,@(ZI,ZJ) ZI.*(ZJ-ZI)./(ZJ+ZI));
        W = abs(W0).^gamma;
        %     W = exp(-W0);
        W = 1e3* W ./ norm(W);
end
end

