function [C,P] = zoom_out_rect(M,N, C,kM_final,kN_final,options)
    arguments
        M struct
        N struct
        C double
        kM_final int16
        kN_final int16
        options.step_sizeM = 1
        options.step_sizeN = 1
    end
    %% optmimization zoom out
    k_init = size(C);
    x = knnsearch(M.evecs(:,1:k_init(1)),N.evecs(:,1:k_init(2))*C');
    P = sparse(x, 1:N.n, 1, M.n, N.n);
    kM =0; kN = 0;
    while kM<kM_final || kN<kN_final 
        if kM<kM_final
            kM = min(kM+options.step_sizeM,kM_final);
        end
        if kN<kN_final
            kN = min(kN+options.step_sizeN,kN_final);
        end
        C = M.evecs(:,1:k_init(1)+kM)'*P*N.evecs(:,1:k_init(2)+kN);

%         fprintf('k tar: %d, k src: %d\n', k, k);

    %     [x,~] = flann_search(C*M.evecs(:,1:k)', N.evecs(:,1:k)', 1, struct());

        % Use the knnsearch line if FLANN is not available.
        % However, expect ~1 order of magnitude loss in speed.
        
        x = knnsearch(M.evecs(:,1:k_init(1)+kM),N.evecs(:,1:k_init(2)+kN)*C');
        P = sparse(x, 1:N.n, 1, M.n, N.n);
    end
end

