function M = load_mesh(name,partiality_type,index)
% M = struct(TRIV,VERT,name)
    switch name
        case 'cat'
            M = load_shrec16(name,partiality_type,index);
    otherwise
            error("datasetLoader: %s is not implemented\n",name);
    end
    
end

function M = load_shrec16(name,partiality_type,index)
    switch partiality_type
        case 'null'
            M = load(sprintf('./data/MESH/shrec2016/pointwise_gt/%s_%s_shape_%i.mat','cuts',name,1)).M;
            M.name = [name];
        case {'cuts',  'holes'}
            M = load(sprintf('./data/MESH/shrec2016/pointwise_gt/%s_%s_shape_%i.mat',partiality_type,name,index)).N;
            M.name = [name '_' partiality_type '_' int2str(index)];
        otherwise
            error("datasetLoader: %s is not implemented\n",name);
    end
    M.n = size(M.VERT,1);
end

