The script `PINN.py` can be used to run the solver for Korteweg–De Vries equation for a various number of scenarios. The different modes can be selected by modifying the command line arguments. The different arguments accepted by the script are summarized below:

| Options | Description|
|---|---|
|**`--nodes`**|      The number of nodes per hidden layer in the neural network|
|**`--N0`** |               The number of points to use on the initial condition|
|**`--Nb`** |               The number of points to use on the boundary condition|
|**`--Nf`** |             The number of collocation points to use|
|**`--Ni`** |              The number of points to use on interfaces for cPINNs|
|**`--Nt`** |              The number of points to use to calculate the MSE loss|
|**`--epochs`**|       The number of epochs to train the neural network|
|**`--display-freq`**|  How often to display loss information|
|**`--layers`**| The number of hidden layers in the neural network|
|**`--beta`**| High residual concentration parameter|
|**`--tau`**| Langevin step size|
|**`--L`**| The number of Langevin iteration|
|**`--method`**| Sampling method|

To run the code: </br>
`cd code` </br>
`python PINN.py <options>`

The weights for the IC, BC, and PDE residual losses are set to 100, 1, and 1, respectively.

The available sampling methods include 'fixed', 'rar', 'rad', 'r3', 'l_inf', and 'lpinn'. In cases where hyperparameter settings are required for each method, the default settings from the original paper have been applied. If modifications are necessary, these should be made within the code. For instance, in 'rad', set k=c=1, and in 'l_inf', set the number of iterations to 20.