import subprocess

BASE_DIR = "../../dataset"
MODEL_ID = "Qwen/Qwen2.5-VL-7B-Instruct"
FOLDERS = [f"wolf_videos/wolf{i:02d}" for i in range(1, 18)]
PROMPTS = [1, 4, 8, 15, 20, 30, 33, 38, 43, 48, 52, 67, 71]

for folder in FOLDERS:
    for prompt in PROMPTS:
        print(f"\n📂 Processing folder: {folder} | 🧠 Prompt: {prompt}")
        result = subprocess.run([
            "python",
            "extract_sentences_videos.py",
            "-d", BASE_DIR,
            "-m", MODEL_ID,
            "-p", str(prompt),
            "-v", folder
        ])
        if result.returncode != 0:
            print(f"❌ Failed for {folder} with prompt {prompt}")
