#!/bin/bash

# Usage check
if [ $# -lt 3 ]; then
    echo "Usage: $0 <subject> <prompt_number> <model_id> [layer_number]"
    exit 1
fi

# Required arguments
subj=$1
prompt=$2
model_id=$3

# Optional layer number
layer_arg=""
if [ $# -eq 4 ]; then
    layer_number=$4
    layer_arg="-l $layer_number"
    echo "Using specified layer number: $layer_number"
else
    echo "Using all layers"
fi

# Constants
BASE_DIR="../../dataset/"
VIDEOS_DIR="../../dataset/"

echo "Running Subject: ${subj}, Prompt: ${prompt}, Model: ${model_id}, Layer: ${layer_number:-all}"

python align_internvl.py \
    -s "$subj" \
    -d "$BASE_DIR" \
    -m "$model_id" \
    -p "$prompt" \
    -v "$VIDEOS_DIR" \
    $layer_arg

echo "✅ Completed subject ${subj}"