# coding=utf-8
# Copyright 2023 The Private Kendall Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Tests for regression."""

from absl.testing import absltest
import numpy as np

from private_kendall import regression


class RegressionTest(absltest.TestCase):

  def test_nondp(self):
    num_points = 100
    features = np.ones((num_points, 2))
    features[:, 0] = np.arange(num_points)
    labels = np.sum(features, axis=1)
    model = regression.nondp(False, features, labels)
    self.assertAlmostEqual(model[0, 0], 1, 2)
    self.assertAlmostEqual(model[1, 0], 1, 2)


if __name__ == '__main__':
  absltest.main()
